/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1;

import com.sosnoski.util.array.IntArray;
import com.sosnoski.util.hashset.IntHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import uk.ac.rhul.cs.cl1.Intersectable;
import uk.ac.rhul.cs.cl1.Sized;
import uk.ac.rhul.cs.graph.BreadthFirstSearch;
import uk.ac.rhul.cs.graph.Directedness;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.stats.independentsamples.MannWhitneyTest;
import uk.ac.rhul.cs.stats.tests.H1;
import uk.ac.rhul.cs.utils.StringUtils;
import uk.ac.rhul.cs.utils.UniqueIDGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSet
implements Iterable<Integer>,
Intersectable<NodeSet>,
Sized {
    protected Graph graph = null;
    protected SortedSet<Integer> members = null;
    protected double totalInternalEdgeWeight = 0.0;
    protected double totalBoundaryEdgeWeight = 0.0;
    protected Double significance = null;

    public NodeSet(Graph graph) {
        this.graph = graph;
    }

    public NodeSet(Graph graph, Collection<Integer> members) {
        this(graph);
        this.setMembers(members);
    }

    public NodeSet(Graph graph, int[] members) {
        this(graph);
        this.setMembers(members);
    }

    public int compareTo(NodeSet other) {
        if (this.members == null && other.members == null) {
            return 0;
        }
        if (this.members == null) {
            return -1;
        }
        if (other.members == null) {
            return 1;
        }
        Iterator it1 = this.members.iterator();
        Iterator it2 = other.members.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Integer i1 = (Integer)it1.next();
            Integer i2 = (Integer)it2.next();
            if (i1 < i2) {
                return -1;
            }
            if (i1 <= i2) continue;
            return 1;
        }
        if (it1.hasNext()) {
            return 1;
        }
        if (it2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public boolean contains(int idx) {
        return this.members.contains(idx);
    }

    public boolean containsAny(Collection<Integer> idxs) {
        for (Integer i : idxs) {
            if (!this.members.contains(i)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Integer> idxs) {
        return this.members.containsAll(idxs);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeSet)) {
            return false;
        }
        NodeSet other = (NodeSet)o;
        return other.graph.equals(this.graph) && other.members.equals(this.members);
    }

    public double getCommitment(int nodeIndex) {
        int[] edgeIdxs;
        IntHashSet memberHashSet = this.getMemberHashSet();
        double in = 0.0;
        double out = 0.0;
        for (int edgeIdx : edgeIdxs = this.graph.getAdjacentEdgeIndicesArray(nodeIndex, Directedness.ALL)) {
            double weight = this.graph.getEdgeWeight(edgeIdx);
            int endpoint = this.graph.getEdgeEndpoint(edgeIdx, nodeIndex);
            if (memberHashSet.contains(endpoint)) {
                in += weight;
                continue;
            }
            out += weight;
        }
        if (in + out == 0.0) {
            return 0.0;
        }
        return in / (in + out);
    }

    public Graph getGraph() {
        return this.graph;
    }

    protected IntHashSet getMemberHashSet() {
        IntHashSet memberSet = new IntHashSet();
        Iterator i$ = this.members.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            memberSet.add(i);
        }
        return memberSet;
    }

    public SortedSet<Integer> getMembers() {
        return new TreeSet<Integer>(this.members);
    }

    public String[] getMemberNames() {
        String[] result = new String[this.members.size()];
        int i = 0;
        for (Integer member : this.members) {
            result[i] = this.graph.getNodeName(member);
            ++i;
        }
        return result;
    }

    public int hashCode() {
        return this.graph.hashCode() + this.members.hashCode();
    }

    public boolean isConnected() {
        if (this.members.size() < 2) {
            return true;
        }
        BreadthFirstSearch bfs = new BreadthFirstSearch(this.graph, this.members.first());
        Integer[] dummy = new Integer[]{};
        bfs.restrictToSubgraph(this.members.toArray(dummy));
        return bfs.toArray().length == this.members.size();
    }

    public boolean isCutVertex(int index) {
        if (this.members.isEmpty()) {
            return false;
        }
        IntArray newMembers = new IntArray();
        Iterator i$ = this.members.iterator();
        while (i$.hasNext()) {
            int member = (Integer)i$.next();
            if (member == index) continue;
            newMembers.add(member);
        }
        if (newMembers.size() == 0) {
            return false;
        }
        BreadthFirstSearch bfs = new BreadthFirstSearch(this.graph, newMembers.get(0));
        bfs.restrictToSubgraph(newMembers.toArray());
        return bfs.toArray().length != newMembers.size();
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    @Override
    public int size() {
        return this.members.size();
    }

    protected void setMembers(Iterable<Integer> members) {
        this.members = new TreeSet<Integer>();
        if (members == null) {
            return;
        }
        for (Integer member : members) {
            this.members.add(member);
        }
        this.recalculate();
    }

    protected void setMembers(int[] members) {
        this.members = new TreeSet<Integer>();
        if (members == null) {
            return;
        }
        for (int member : members) {
            this.members.add(member);
        }
        this.recalculate();
    }

    protected void recalculate() {
        IntHashSet memberHashSet = this.getMemberHashSet();
        this.totalBoundaryEdgeWeight = 0.0;
        this.totalInternalEdgeWeight = 0.0;
        Iterator i$ = this.members.iterator();
        while (i$.hasNext()) {
            int[] edgeIdxs;
            int i = (Integer)i$.next();
            for (int edgeIdx : edgeIdxs = this.graph.getAdjacentEdgeIndicesArray(i, Directedness.ALL)) {
                double weight = this.graph.getEdgeWeight(edgeIdx);
                int endpoint = this.graph.getEdgeEndpoint(edgeIdx, i);
                if (memberHashSet.contains(endpoint)) {
                    this.totalInternalEdgeWeight += weight;
                    continue;
                }
                this.totalBoundaryEdgeWeight += weight;
            }
        }
        this.totalInternalEdgeWeight /= 2.0;
    }

    public double getDensity() {
        if (this.size() < 2) {
            return 0.0;
        }
        return 2.0 * this.totalInternalEdgeWeight / (double)(this.size() * (this.size() - 1));
    }

    public double getInternalWeight(int nodeIndex) {
        int[] edgeIdxs;
        IntHashSet memberHashSet = this.getMemberHashSet();
        double result = 0.0;
        for (int edgeIdx : edgeIdxs = this.graph.getAdjacentEdgeIndicesArray(nodeIndex, Directedness.ALL)) {
            double weight = this.graph.getEdgeWeight(edgeIdx);
            int endpoint = this.graph.getEdgeEndpoint(edgeIdx, nodeIndex);
            if (!memberHashSet.contains(endpoint)) continue;
            result += weight;
        }
        return result;
    }

    @Override
    public NodeSet getIntersectionWith(NodeSet other) {
        SortedSet<Integer> smaller = null;
        IntHashSet larger = null;
        IntArray intersection = new IntArray();
        if (this.size() < other.size()) {
            smaller = this.members;
            larger = other.getMemberHashSet();
        } else {
            smaller = other.members;
            larger = this.getMemberHashSet();
        }
        Iterator i$ = smaller.iterator();
        while (i$.hasNext()) {
            int member = (Integer)i$.next();
            if (!larger.contains(member)) continue;
            intersection.add(member);
        }
        return new NodeSet(this.getGraph(), intersection.toArray());
    }

    @Override
    public int getIntersectionSizeWith(NodeSet other) {
        int isectSize = 0;
        SortedSet<Integer> smaller = null;
        IntHashSet larger = null;
        if (this.size() < other.size()) {
            smaller = this.members;
            larger = other.getMemberHashSet();
        } else {
            smaller = other.members;
            larger = this.getMemberHashSet();
        }
        Iterator i$ = smaller.iterator();
        while (i$.hasNext()) {
            int member = (Integer)i$.next();
            if (!larger.contains(member)) continue;
            ++isectSize;
        }
        return isectSize;
    }

    public double getSignificance() {
        if (this.significance == null) {
            this.significance = this.getSignificanceReal();
        }
        return this.significance;
    }

    protected double getSignificanceReal() {
        double[] inWeights = new double[this.size()];
        double[] outWeights = new double[this.size()];
        IntHashSet memberHashSet = this.getMemberHashSet();
        int j = 0;
        Arrays.fill(inWeights, 0.0);
        Arrays.fill(outWeights, 0.0);
        j = 0;
        Iterator i$ = this.members.iterator();
        while (i$.hasNext()) {
            int[] edgeIdxs;
            int i = (Integer)i$.next();
            for (int edgeIdx : edgeIdxs = this.graph.getAdjacentEdgeIndicesArray(i, Directedness.ALL)) {
                double weight = this.graph.getEdgeWeight(edgeIdx);
                int endpoint = this.graph.getEdgeEndpoint(edgeIdx, i);
                if (memberHashSet.contains(endpoint)) {
                    int n = j;
                    inWeights[n] = inWeights[n] + weight;
                    continue;
                }
                int n = j;
                outWeights[n] = outWeights[n] + weight;
            }
            ++j;
        }
        MannWhitneyTest test = new MannWhitneyTest(inWeights, outWeights, H1.GREATER_THAN);
        return test.getSP();
    }

    public Graph getSubgraph() {
        boolean directed = this.getGraph().isDirected();
        Graph result = new Graph(directed);
        IntHashSet memberSet = this.getMemberHashSet();
        UniqueIDGenerator<Integer> idGen = new UniqueIDGenerator<Integer>(result);
        Iterator i$ = this.members.iterator();
        while (i$.hasNext()) {
            int[] edgeIdxs;
            int i = (Integer)i$.next();
            int srcId = idGen.get(i);
            for (int edgeIdx : edgeIdxs = this.graph.getAdjacentEdgeIndicesArray(i, Directedness.OUT)) {
                int endpoint = this.graph.getEdgeEndpoint(edgeIdx, i);
                if (!memberSet.contains(endpoint) || !directed && i > endpoint) continue;
                result.createEdge(srcId, idGen.get(endpoint), this.graph.getEdgeWeight(edgeIdx));
            }
        }
        return result;
    }

    public double getTotalInternalEdgeWeight() {
        return this.totalInternalEdgeWeight;
    }

    public double getTotalBoundaryEdgeWeight() {
        return this.totalBoundaryEdgeWeight;
    }

    public Set<Integer> getExternalBoundaryNodeIterator() {
        IntHashSet memberSet = this.getMemberHashSet();
        TreeSet<Integer> result = new TreeSet<Integer>();
        Iterator i$ = this.members.iterator();
        while (i$.hasNext()) {
            int[] edgeIdxs;
            int i = (Integer)i$.next();
            for (int edgeIdx : edgeIdxs = this.graph.getAdjacentEdgeIndicesArray(i, Directedness.ALL)) {
                int endpoint = this.graph.getEdgeEndpoint(edgeIdx, i);
                if (memberSet.contains(endpoint)) continue;
                result.add(endpoint);
            }
        }
        return result;
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.members.iterator();
    }

    public String toString() {
        return this.toString(" ");
    }

    public String toString(String separator) {
        return StringUtils.join((Object[])this.getMemberNames(), separator);
    }
}

