/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FrequencyModel
extends AbstractModel {
    private DataType dataType = null;
    Parameter frequencyParameter = null;

    public FrequencyModel(DataType dataType, double[] dArray) {
        this(dataType, new Parameter.Default(dArray));
    }

    public FrequencyModel(DataType dataType, Parameter parameter) {
        super("frequencyModel");
        double d = this.getSumOfFrequencies(parameter);
        if (Math.abs(d - 1.0) > 1.0E-8) {
            throw new IllegalArgumentException("Frequencies do not sum to 1, they sum to " + d);
        }
        this.frequencyParameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(1.0, 0.0, parameter.getDimension()));
        this.dataType = dataType;
    }

    private double getSumOfFrequencies(Parameter parameter) {
        double d = 0.0;
        for (int i = 0; i < parameter.getDimension(); ++i) {
            d += parameter.getParameterValue(i);
        }
        return d;
    }

    public void setFrequency(int n, double d) {
        this.frequencyParameter.setParameterValue(n, d);
    }

    public double getFrequency(int n) {
        return this.frequencyParameter.getParameterValue(n);
    }

    public int getFrequencyCount() {
        return this.frequencyParameter.getDimension();
    }

    public Parameter getFrequencyParameter() {
        return this.frequencyParameter;
    }

    public double[] getFrequencies() {
        double[] dArray = new double[this.getFrequencyCount()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.getFrequency(i);
        }
        return dArray;
    }

    public double[] getCumulativeFrequencies() {
        double[] dArray = this.getFrequencies();
        for (int i = 1; i < dArray.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] + dArray[i - 1];
        }
        return dArray;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }
}

