/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.operators;

import dr.evomodel.antigenic.phyloclustering.TreeClusteringSharedRoutines;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class Mu2ScaleActiveScaledMu2IntactOperator
extends AbstractAdaptableOperator {
    private MatrixParameter mu = null;
    private Parameter mu2Scale = null;
    private MatrixParameter virusLocations = null;
    private MatrixParameter virusLocationsTreeNode = null;
    private Parameter indicators;
    private TreeModel treeModel;
    private int numdata;
    private int numNodes;
    private int[] correspondingTreeIndexForVirus = null;
    private double scaleFactor;
    public static final String MU2SCALEACTIVEACTIVEMU2INTACTOPERATOR = "Mu2ScaleActiveScaledMu2IntactOperator";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String VIRUSLOCATIONS = "virusLocations";
        public static final String VIRUSLOCATIONSTREENODE = "virusLocationsTreeNodes";
        public static final String MU = "mu";
        public static final String MU2SCALE = "mu2Scale";
        public static final String INDICATORS = "indicators";
        public static final String SCALE = "scaleFactor";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), AttributeRule.newDoubleRule("scaleFactor"), new ElementRule("virusLocations", Parameter.class), new ElementRule("virusLocationsTreeNodes", MatrixParameter.class), new ElementRule("mu", Parameter.class), new ElementRule("indicators", Parameter.class), new ElementRule("mu2Scale", Parameter.class), new ElementRule(TreeModel.class)};

        @Override
        public String getParserName() {
            return Mu2ScaleActiveScaledMu2IntactOperator.MU2SCALEACTIVEACTIVEMU2INTACTOPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute(SCALE);
            XMLObject xMLObject2 = xMLObject.getChild(VIRUSLOCATIONS);
            MatrixParameter matrixParameter = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(VIRUSLOCATIONSTREENODE);
            MatrixParameter matrixParameter2 = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(MU);
            MatrixParameter matrixParameter3 = (MatrixParameter)xMLObject2.getChild(MatrixParameter.class);
            xMLObject2 = xMLObject.getChild(INDICATORS);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            xMLObject2 = xMLObject.getChild(MU2SCALE);
            Parameter parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            return new Mu2ScaleActiveScaledMu2IntactOperator(d, matrixParameter, matrixParameter3, parameter, parameter2, treeModel, d2, matrixParameter2);
        }

        @Override
        public String getParserDescription() {
            return "changes mu1Scale and make sure the first dimension of the active drifted mus stay the same";
        }

        @Override
        public Class getReturnType() {
            return Mu2ScaleActiveScaledMu2IntactOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public Mu2ScaleActiveScaledMu2IntactOperator(double d, MatrixParameter matrixParameter, MatrixParameter matrixParameter2, Parameter parameter, Parameter parameter2, TreeModel treeModel, double d2, MatrixParameter matrixParameter3) {
        super(AdaptationMode.ADAPTATION_ON);
        this.setWeight(d);
        this.virusLocations = matrixParameter;
        this.mu = matrixParameter2;
        this.indicators = parameter;
        this.mu2Scale = parameter2;
        this.treeModel = treeModel;
        this.scaleFactor = d2;
        this.virusLocationsTreeNode = matrixParameter3;
        this.numNodes = this.treeModel.getNodeCount();
        this.numdata = matrixParameter.getColumnDimension();
        this.correspondingTreeIndexForVirus = TreeClusteringSharedRoutines.setMembershipTreeToVirusIndexes(this.numdata, matrixParameter, this.numNodes, this.treeModel);
        TreeClusteringSharedRoutines.updateUndriftedVirusLocations(this.numNodes, this.numdata, this.treeModel, this.virusLocationsTreeNode, parameter, matrixParameter2, matrixParameter, this.correspondingTreeIndexForVirus);
    }

    @Override
    public double doOperation() {
        double d = this.scaleFactor + MathUtils.nextDouble() * (1.0 / this.scaleFactor - this.scaleFactor);
        double d2 = this.mu2Scale.getParameterValue(0);
        double d3 = d * d2;
        this.mu2Scale.setParameterValue(0, d3);
        for (int i = 0; i < this.numNodes; ++i) {
            if ((int)this.indicators.getParameterValue(i) != 1) continue;
            double d4 = this.mu.getParameter(i).getParameterValue(1);
            double d5 = d4 * d2 / d3;
            this.mu.getParameter(i).setParameterValue(1, d5);
        }
        TreeClusteringSharedRoutines.updateUndriftedVirusLocations(this.numNodes, this.numdata, this.treeModel, this.virusLocationsTreeNode, this.indicators, this.mu, this.virusLocations, this.correspondingTreeIndexForVirus);
        double d6 = -Math.log(d);
        return d6;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(1.0 / this.scaleFactor - 1.0);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.scaleFactor = 1.0 / (Math.exp(d) + 1.0);
    }

    @Override
    public double getRawParameter() {
        return this.scaleFactor;
    }

    @Override
    public String getAdaptableParameterName() {
        return "scaleFactor";
    }

    @Override
    public final String getOperatorName() {
        return MU2SCALEACTIVEACTIVEMU2INTACTOPERATOR;
    }

    public int getStepCount() {
        return 1;
    }
}

