/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.IntervalList;
import dr.evolution.coalescent.IntervalType;
import dr.evolution.coalescent.TreeIntervals;
import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.math.Binomial;

public class Skyline
implements Units {
    private IntervalList intervals;
    private int size;
    private double maxTime;
    private double eps;
    private double mu;
    private int params;
    private double[] cis;
    private double[] populationSize;

    Skyline() {
    }

    public Skyline(Tree tree, double d) {
        this(new TreeIntervals(tree), 1.0, d);
    }

    public Skyline(Tree tree, double d, double d2) {
        this(new TreeIntervals(tree), d, d2);
    }

    public Skyline(IntervalList intervalList, double d, double d2) {
        this.init(intervalList, d, d2);
    }

    void init(IntervalList intervalList, double d, double d2) {
        if (!intervalList.isBinaryCoalescent()) {
            throw new IllegalArgumentException("All intervals must contain only a single coalescent");
        }
        this.mu = d;
        this.size = intervalList.getIntervalCount();
        this.intervals = intervalList;
        this.populationSize = new double[this.size];
        this.cis = new double[this.size];
        this.maxTime = 0.0;
        for (int i = 0; i < this.size; ++i) {
            this.cis[i] = this.maxTime;
            this.maxTime += intervalList.getInterval(i) / this.mu;
        }
        if (d2 == 0.0) {
            this.computeClassic();
        } else if (d2 > 0.0) {
            this.computeGeneralized(d2);
        } else {
            this.optimize();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Skyline Plot ");
        if (this.eps == 0.0) {
            stringBuffer.append("(classic): ");
        } else {
            stringBuffer.append("(generalized): ");
            stringBuffer.append("epsilon = " + this.eps + ", ");
        }
        stringBuffer.append("log L = " + this.getLogLikelihood());
        if (this.params > this.size - 2) {
            stringBuffer.append("\tlog L(AICC) not available");
        } else {
            stringBuffer.append("\tlog L(AICC) = " + this.getAICC());
        }
        return stringBuffer.toString();
    }

    public void computeClassic() {
        int n = 0;
        int n2 = 0;
        do {
            double d = 0.0;
            boolean bl = false;
            n2 = n;
            do {
                double d2 = this.intervals.getInterval(n) / this.mu;
                int n3 = this.intervals.getLineageCount(n);
                if (n3 < 0) {
                    n3 = 0;
                }
                bl = this.intervals.getIntervalType(n) == IntervalType.COALESCENT;
                d += d2 * Binomial.choose2(n3);
            } while (++n < this.size && !bl);
            for (int i = n2; i < n; ++i) {
                this.populationSize[i] = d;
            }
        } while (n < this.size);
        this.params = n2;
        this.eps = 0.0;
    }

    public void computeGeneralized(double d) {
        this.params = 0;
        double d2 = 0.0;
        for (int i = 0; i < this.size; ++i) {
            double d3;
            int n = this.intervals.getLineageCount(i);
            if (n < 0) {
                n = 0;
            }
            int n2 = i;
            int n3 = 1;
            for (d3 = this.intervals.getInterval(i) / this.mu; d3 < d && i < this.size - 1 || this.intervals.getIntervalType(i) != IntervalType.COALESCENT; d3 += this.intervals.getInterval(++i) / this.mu) {
                ++n3;
            }
            if (this.maxTime - d2 - d3 < d) {
                for (int j = i + 1; j < this.size; ++j) {
                    ++n3;
                    d3 += this.intervals.getInterval(++i) / this.mu;
                }
            }
            double d4 = d3 * Binomial.choose2(n) / (double)n3;
            for (int j = n2; j < n2 + n3; ++j) {
                this.populationSize[j] = d4;
            }
            ++this.params;
            d2 += d3;
        }
        this.eps = d;
    }

    public void optimize() {
        double d = this.getMaxTime();
        this.computeGeneralized(d);
        double d2 = this.getAICC();
        int n = 1000;
        double d3 = d / (double)n;
        double d4 = 1.0E-6;
        this.eps -= d3;
        while (this.eps > d4) {
            this.computeGeneralized(this.eps);
            double d5 = this.getAICC();
            if (d5 > d2 && this.params < this.size - 1) {
                d = this.eps;
                d2 = d5;
            }
            this.eps -= d3;
        }
        this.computeGeneralized(d);
    }

    public double getLogLikelihood() {
        double d = 0.0;
        for (int i = 0; i < this.size; ++i) {
            double d2 = this.intervals.getInterval(i);
            double d3 = this.populationSize[i];
            double d4 = this.intervals.getIntervalCount();
            double d5 = d4 * (d4 - 1.0) / 2.0;
            if (this.intervals.getIntervalType(i) == IntervalType.COALESCENT) {
                d += Math.log(d5 / d3) - d2 * d5 / d3;
                continue;
            }
            d -= d2 * d5 / d3;
        }
        return d;
    }

    public double getAICC() {
        double d = this.getLogLikelihood();
        return Skyline.AICC(d, this.params, this.size);
    }

    public static double AICC(double d, int n, int n2) {
        if (n > n2 - 2) {
            throw new IllegalArgumentException("k must be smaller than n-1");
        }
        return d - (double)n - (double)n * ((double)n + 1.0) / ((double)(n2 - n) - 1.0);
    }

    public double findInterval(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative values for time are not allowed");
        }
        for (int i = 0; i < this.size - 1; ++i) {
            if (!(d >= this.cis[i]) || !(d < this.cis[i + 1])) continue;
            return i;
        }
        return this.size - 1;
    }

    public double getMaxTime() {
        return this.maxTime;
    }

    public double getMaxPopulationSize() {
        double d = 0.0;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.populationSize[i] > d)) continue;
            d = this.populationSize[i];
        }
        return d;
    }

    public IntervalList getIntervals() {
        return this.intervals;
    }

    public int getSize() {
        return this.size;
    }

    public int getParameterCount() {
        return this.params;
    }

    public double getEpsilon() {
        return this.eps;
    }

    public double getPopulationSize(int n) {
        return this.populationSize[n];
    }

    @Override
    public final Units.Type getUnits() {
        return this.intervals.getUnits();
    }

    @Override
    public final void setUnits(Units.Type type) {
        throw new IllegalArgumentException("Can't set skyline's units");
    }
}

