/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jsondiagram;

import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.plantuml.Previous;
import net.sourceforge.plantuml.abel.DisplayPositioned;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.json.ParseException;
import net.sourceforge.plantuml.jsondiagram.JsonDiagram;
import net.sourceforge.plantuml.jsondiagram.StyleExtractor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.parser.StyleParsingException;
import net.sourceforge.plantuml.yaml.Highlighted;

public class JsonDiagramFactory
extends PSystemAbstractFactory {
    public JsonDiagramFactory() {
        super(DiagramType.JSON);
    }

    @Override
    public Diagram createSystem(UmlSource source, Previous previous, PreprocessingArtifact preprocessing) {
        JsonValue json;
        ArrayList<Highlighted> highlighted = new ArrayList<Highlighted>();
        StyleExtractor styleExtractor = null;
        try {
            StringBuilder sb = new StringBuilder();
            styleExtractor = new StyleExtractor(source.iterator2());
            Iterator<String> it = styleExtractor.getIterator();
            it.next();
            while (true) {
                String line = it.next();
                if (!it.hasNext()) break;
                if (line.startsWith("#")) {
                    if (!Highlighted.matchesDefinition(line)) continue;
                    highlighted.add(Highlighted.build(line));
                    continue;
                }
                sb.append(line);
                sb.append('\n');
            }
            json = Json.parse(sb.toString());
        }
        catch (ParseException e) {
            json = null;
        }
        JsonDiagram result = new JsonDiagram(source, UmlDiagramType.JSON, json, highlighted, styleExtractor, preprocessing);
        if (styleExtractor != null) {
            try {
                styleExtractor.applyStyles(result.getSkinParam());
            }
            catch (StyleParsingException e) {
                Logme.error(e);
            }
            String title = styleExtractor.getTitle();
            if (title != null) {
                result.setTitle(DisplayPositioned.single(Display.getWithNewlines(result.getPragma(), title), HorizontalAlignment.CENTER, VerticalAlignment.CENTER));
            }
        }
        return result;
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.JSON;
    }
}

