/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import net.sourceforge.plantuml.json.Json;
import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.tim.EaterForeach;
import net.sourceforge.plantuml.tim.iterator.CodePosition;

public class ExecutionContextForeach {
    private final String varname;
    private final JsonValue jsonValue;
    private final CodePosition codePosition;
    private boolean skipMe;
    private int currentIndex;

    private ExecutionContextForeach(String varname, JsonValue jsonValue, CodePosition codePosition) {
        this.varname = varname;
        this.jsonValue = jsonValue;
        this.codePosition = codePosition;
    }

    public static ExecutionContextForeach fromValue(String varname, JsonValue jsonValue, CodePosition codePosition) {
        return new ExecutionContextForeach(varname, jsonValue, codePosition);
    }

    public void skipMeNow() {
        this.skipMe = true;
    }

    public final boolean isSkipMe() {
        return this.skipMe;
    }

    public CodePosition getStartForeach() {
        return this.codePosition;
    }

    public JsonValue currentValue() {
        if (this.jsonValue instanceof JsonArray) {
            return ((JsonArray)this.jsonValue).get(this.currentIndex);
        }
        if (this.jsonValue instanceof JsonObject) {
            JsonObject tmp = (JsonObject)this.jsonValue;
            return Json.value(tmp.names().get(this.currentIndex));
        }
        throw new IllegalStateException();
    }

    public final void inc() {
        ++this.currentIndex;
        if (this.currentIndex >= EaterForeach.size(this.jsonValue)) {
            this.skipMe = true;
        }
    }

    public final String getVarname() {
        return this.varname;
    }

    public final JsonValue getJsonValue() {
        return this.jsonValue;
    }
}

