/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.url.Url;

public class EntityImageChenEntity
extends AbstractEntityImage {
    private final boolean isWeak = this.hasStereotype("<<weak>>");
    private final TextBlock title;
    private final Url url;

    public EntityImageChenEntity(Entity entity) {
        super(entity);
        FontConfiguration titleFontConfiguration = EntityImageChenEntity.getStyleStateTitle(entity, this.getSkinParam()).getFontConfiguration(this.getSkinParam().getIHtmlColorSet(), entity.getColors());
        this.title = entity.getDisplay().create8(titleFontConfiguration, HorizontalAlignment.CENTER, this.getSkinParam(), CreoleMode.FULL, this.getStyleState().wrapWidth());
        this.url = entity.getUrl99();
    }

    private boolean hasStereotype(String stereotype) {
        return this.getEntity().getStereotype() != null && this.getEntity().getStereotype().toString().contains(stereotype);
    }

    private Style getStyleState() {
        return EntityImageChenEntity.getStyleState(this.getEntity(), this.getSkinParam());
    }

    private static Style getStyleState(Entity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chenEerDiagram, SName.chenEntity).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    private static Style getStyleStateTitle(Entity group, ISkinParam skinParam) {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.chenEerDiagram, SName.chenEntity, SName.title).withTOBECHANGED(group.getStereotype()).getMergedStyle(skinParam.getCurrentStyleBuilder());
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.title.calculateDimension(stringBounder);
        return dim.delta(20.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug.startGroup(UGroup.singletonMap(UGroupType.ID, this.getEntity().getQuark().toStringPoint()));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        XDimension2D dimTotal = this.calculateDimension(ug.getStringBounder());
        XDimension2D dimTitle = this.title.calculateDimension(ug.getStringBounder());
        UStroke stroke = this.getStyleState().getStroke(this.getEntity().getColors());
        ug = this.applyColor(ug);
        ug = ug.apply(stroke);
        ug.draw(this.getShape(dimTotal));
        if (this.isWeak) {
            ug.apply(new UTranslate(3.0, 3.0)).draw(this.getShape(dimTotal.delta(-6.0)));
        }
        double xTitle = (dimTotal.getWidth() - dimTitle.getWidth()) / 2.0;
        double yTitle = 10.0;
        this.title.drawU(ug.apply(new UTranslate(xTitle, 10.0)));
        if (this.url != null) {
            ug.closeUrl();
        }
        ug.closeGroup();
    }

    protected final UGraphic applyColor(UGraphic ug) {
        Colors colors = this.getEntity().getColors();
        HColor border = colors.getColor(ColorType.LINE);
        if (border == null) {
            border = this.getStyleState().value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(border);
        HColor backcolor = colors.getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = this.getStyleState().value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        ug = ug.apply(backcolor.bg());
        return ug;
    }

    private URectangle getShape(XDimension2D dimTotal) {
        return URectangle.build(dimTotal);
    }
}

