/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.Objects;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.DarkString;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.style.ValueColor;

public class ValueImpl
implements Value {
    private final DarkString value;

    public static ValueImpl dark(String value, AutomaticCounter counter) {
        return new ValueImpl(new DarkString(null, Objects.requireNonNull(value), counter.getNextInt()));
    }

    public static ValueImpl regular(String value, AutomaticCounter counter) {
        return new ValueImpl(new DarkString(Objects.requireNonNull(value), null, counter.getNextInt()));
    }

    public static ValueImpl regular(String value, int priority) {
        return new ValueImpl(new DarkString(Objects.requireNonNull(value), null, priority));
    }

    public Value mergeWith(Value other) {
        if (other == null) {
            return this;
        }
        if (other instanceof ValueImpl) {
            return new ValueImpl(this.value.mergeWith(((ValueImpl)other).value));
        }
        if (other instanceof ValueColor) {
            if (other.getPriority() > this.getPriority()) {
                return other;
            }
            return this;
        }
        throw new UnsupportedOperationException();
    }

    private ValueImpl(DarkString value) {
        this.value = value;
    }

    public Value addPriority(int delta) {
        return new ValueImpl(this.value.addPriority(delta));
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public String asString() {
        return this.value.getValue1();
    }

    @Override
    public HColor asColor(HColorSet set) {
        String value1 = this.value.getValue1();
        if ("none".equalsIgnoreCase(value1)) {
            return HColors.transparent();
        }
        if ("transparent".equalsIgnoreCase(value1)) {
            return HColors.transparent();
        }
        if (value1 == null) {
            throw new IllegalArgumentException(this.value.toString());
        }
        HColor result = set.getColorOrWhite(value1);
        if (this.value.getValue2() != null) {
            HColor dark = set.getColorOrWhite(this.value.getValue2());
            return result.withDark(dark);
        }
        return result;
    }

    @Override
    public boolean asBoolean() {
        return "true".equalsIgnoreCase(this.value.getValue1());
    }

    @Override
    public int asInt(boolean minusOneIfError) {
        String s = this.extractDigits(this.value.getValue1());
        if (s.length() == 0) {
            return minusOneIfError ? -1 : 0;
        }
        return Integer.parseInt(s);
    }

    private String extractDigits(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private String extractDigitsAndDot(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ((c < '0' || c > '9') && c != '.') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public double asDouble() {
        String s = this.extractDigitsAndDot(this.value.getValue1());
        return Double.parseDouble(s);
    }

    @Override
    public double asDoubleDefaultTo(double defaultValue) {
        String s = this.extractDigitsAndDot(this.value.getValue1());
        if (s.length() > 0) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public int asFontStyle() {
        if (this.value.getValue1().equalsIgnoreCase("bold")) {
            return 1;
        }
        if (this.value.getValue1().equalsIgnoreCase("italic")) {
            return 2;
        }
        return 0;
    }

    @Override
    public HorizontalAlignment asHorizontalAlignment() {
        return HorizontalAlignment.fromString(this.asString());
    }

    @Override
    public int getPriority() {
        return this.value.getPriority();
    }
}

