/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.HashMap;
import java.util.Map;

public class StringTrie<V> {
    private final Node<V> root = new Node();

    public void put(String key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Node node = this.root;
        for (int i = 0; i < key.length(); ++i) {
            char c = Character.toLowerCase(key.charAt(i));
            node = node.children.computeIfAbsent(Character.valueOf(c), k -> new Node());
        }
        node.value = value;
    }

    public V get(String key) {
        if (key == null) {
            return null;
        }
        Node<V> node = this.root;
        for (int i = 0; i < key.length(); ++i) {
            char c = Character.toLowerCase(key.charAt(i));
            node = node.children.get(Character.valueOf(c));
            if (node != null) continue;
            return null;
        }
        return node.value;
    }

    private static class Node<V> {
        V value;
        Map<Character, Node<V>> children = new HashMap<Character, Node<V>>();

        private Node() {
        }
    }
}

