/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import java.util.List;
import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class ETileRegexGroup
extends ETile {
    private final List<String> elements;
    private final FontConfiguration fc;
    private final Style style;
    private final HColorSet colorSet;
    private final ISkinParam skinParam;

    public ETileRegexGroup(List<String> elements, FontConfiguration fc, Style style, HColorSet colorSet, ISkinParam skinParam) {
        this.skinParam = skinParam;
        this.elements = elements;
        this.fc = fc;
        this.style = style;
        this.colorSet = colorSet;
    }

    private double getPureH1(StringBounder stringBounder) {
        double height = this.getTextDim(stringBounder).getHeight();
        return height / 2.0;
    }

    @Override
    public double getH1(StringBounder stringBounder) {
        return this.getPureH1(stringBounder);
    }

    @Override
    public double getH2(StringBounder stringBounder) {
        return this.getPureH1(stringBounder);
    }

    @Override
    public double getWidth(StringBounder stringBounder) {
        return this.getTextDim(stringBounder).getWidth() + 10.0;
    }

    private XDimension2D getTextDim(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (String element : this.elements) {
            XDimension2D dim = stringBounder.calculateDimension(this.fc.getFont(), element);
            width = Math.max(width, dim.getWidth());
            height += dim.getHeight();
        }
        return new XDimension2D(width, height);
    }

    private XDimension2D getBoxDim(StringBounder stringBounder) {
        return this.getTextDim(stringBounder).delta(10.0, 0.0);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dim = this.calculateDimension(stringBounder);
        XDimension2D dimText = this.getTextDim(stringBounder);
        XDimension2D dimBox = this.getBoxDim(stringBounder);
        HColor lineColor = this.style.value(PName.LineColor).asColor(this.colorSet);
        HColor backgroundColor = this.style.value(PName.BackGroundColor).asColor(this.colorSet);
        double posxBox = (dim.getWidth() - dimBox.getWidth()) / 2.0;
        URectangle rect = URectangle.build(dimBox);
        ug.apply(new UTranslate(posxBox, 0.0)).apply(lineColor).apply(new UStroke(5.0, 5.0, 1.0)).draw(rect);
        double y = 0.0;
        for (String element : this.elements) {
            UText utext = UText.build(element, this.fc);
            XDimension2D dimElement = utext.calculateDimension(stringBounder);
            ug.apply(new UTranslate(5.0 + posxBox, y + dimElement.getHeight() - utext.getDescent(stringBounder))).draw(utext);
            if (y > 0.0) {
                this.drawHline(ug.apply(UStroke.withThickness(0.3)), y, 0.0, dimBox.getWidth());
            }
            y += dimElement.getHeight();
        }
        if (posxBox > 0.0) {
            this.drawHlineDirected(ug, this.getH1(stringBounder), 0.0, posxBox, 0.5, 25.0);
            this.drawHlineDirected(ug, this.getH1(stringBounder), posxBox + dimBox.getWidth(), dim.getWidth(), 0.5, 25.0);
        }
    }

    @Override
    public void push(ETile tile) {
        throw new UnsupportedOperationException();
    }
}

