/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.directdot;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.PSystemBasicFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.directdot.PSystemDot;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.UmlDiagramType;

public class PSystemDotFactory
extends PSystemBasicFactory<PSystemDot> {
    private StringBuilder data;
    private static final Pattern GRAPHVIZ_DOT_HEADER_PATTERN = Pattern.compile("\\s*(strict\\s+)?(di)?graph\\s+([_\\p{L}][_\\p{L}\\p{N}]*|-?(?:\\.[0-9]+|[0-9]+(?:\\.[0-9]*)?)|\"([^\"\\\\]|\\\\\")*\")?\\s*\\{\\s*");

    public PSystemDotFactory(DiagramType diagramType) {
        super(diagramType);
    }

    @Override
    public PSystemDot initDiagram(UmlSource source, String startLine, PreprocessingArtifact preprocessing) {
        this.data = null;
        return null;
    }

    @Override
    public PSystemDot executeLine(UmlSource source, PSystemDot system, String line, PreprocessingArtifact preprocessing) {
        if (system == null && this.isGraphvizDotHeader(line)) {
            this.data = new StringBuilder(line);
            this.data.append("\n");
            return new PSystemDot(source, this.data.toString(), preprocessing);
        }
        if (this.data == null || system == null) {
            return null;
        }
        this.data.append(line);
        this.data.append("\n");
        return new PSystemDot(source, this.data.toString(), preprocessing);
    }

    private boolean isGraphvizDotHeader(String line) {
        Matcher matcher = GRAPHVIZ_DOT_HEADER_PATTERN.matcher(line);
        return matcher.matches();
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return null;
    }
}

