/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.crash;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.atmp.ImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.crash.CrashImage;
import net.sourceforge.plantuml.crash.ReportLog;
import net.sourceforge.plantuml.security.SecurityUtils;

public class CrashReportHandler
extends ReportLog {
    private final Throwable exception;
    private final String metadata;
    private final String flash;

    public CrashReportHandler(Throwable exception, String metadata, String flash) {
        this.metadata = metadata;
        this.exception = exception;
        this.flash = flash;
    }

    public void exportDiagramError(FileFormatOption fileFormat, long seed, OutputStream os) throws IOException {
        if (fileFormat.getFileFormat() == FileFormat.ATXT || fileFormat.getFileFormat() == FileFormat.UTXT) {
            this.exportDiagramErrorText(os, this.exception);
            return;
        }
        CrashImage image = new CrashImage(this.exception, this.flash, this);
        ImageBuilder.create(fileFormat, image).metadata(this.metadata).seed(seed).write(os);
    }

    private void exportDiagramErrorText(OutputStream os, Throwable exception) {
        PrintWriter pw = SecurityUtils.createPrintWriter(os);
        exception.printStackTrace(pw);
        pw.println();
        pw.println();
        for (String s : this) {
            s = s.replaceAll("\\</?\\w+?\\>", "");
            pw.println(s);
        }
        pw.flush();
    }
}

