/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.TextNavigator;
import java.util.Set;

public enum CharClassRaw {
    ANY("."){

        @Override
        boolean internalMatches(char ch) {
            return true;
        }
    }
    ,
    SPACE("s"){

        @Override
        boolean internalMatches(char ch) {
            return ch == ' ';
        }
    }
    ,
    GUILLEMET("g"){

        @Override
        boolean internalMatches(char ch) {
            return ch == '\"' || ch == '\u201c' || ch == '\u201d';
        }
    }
    ,
    WORD("w"){

        @Override
        boolean internalMatches(char ch) {
            return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_';
        }
    }
    ,
    DIGIT("d"){

        @Override
        boolean internalMatches(char ch) {
            return ch >= '0' && ch <= '9' || ch == '_';
        }
    }
    ,
    ALPHA_NUMERIC("an"){

        @Override
        boolean internalMatches(char ch) {
            return Character.isLetterOrDigit(ch);
        }
    }
    ,
    LETTER("le"){

        @Override
        boolean internalMatches(char ch) {
            return Character.isLetter(ch);
        }
    };

    private final String syntax;

    abstract boolean internalMatches(char var1);

    private CharClassRaw(String syntax) {
        this.syntax = syntax;
    }

    public int getDefinitionLength() {
        return this.syntax.length();
    }

    public static CharClassRaw fromDefinition(TextNavigator nav) {
        char ch = nav.charAt(0);
        switch (ch) {
            case 'S': 
            case 's': {
                return SPACE;
            }
            case 'G': 
            case 'g': {
                return GUILLEMET;
            }
            case 'D': 
            case 'd': {
                return DIGIT;
            }
            case 'W': 
            case 'w': {
                return WORD;
            }
            case 'A': 
            case 'a': {
                return ALPHA_NUMERIC;
            }
            case 'L': 
            case 'l': {
                return LETTER;
            }
            case '.': {
                return ANY;
            }
        }
        throw new UnsupportedOperationException("wip01class " + ch);
    }

    public static boolean internalMatchesAny(Set<CharClassRaw> set, char ch) {
        for (CharClassRaw charClass : set) {
            if (!charClass.internalMatches(ch)) continue;
            return true;
        }
        return false;
    }
}

