/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Capture {
    public static final Capture EMPTY = new Capture();
    private List<Map.Entry<String, String>> list;

    private Capture() {
    }

    private List<Map.Entry<String, String>> getList() {
        if (this.list == null) {
            this.list = new ArrayList<Map.Entry<String, String>>();
        }
        return this.list;
    }

    public List<Map.Entry<String, String>> getCaptures() {
        if (this.list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.list);
    }

    public String toString() {
        if (this.list == null) {
            return "[]";
        }
        return this.getCaptures().toString();
    }

    public Capture withEntry(String key, String value) {
        Capture copy = new Capture();
        if (this.list != null) {
            copy.getList().addAll(this.list);
        }
        copy.getList().add(new AbstractMap.SimpleEntry<String, String>(key, value));
        return copy;
    }

    public Capture merge(Capture other) {
        if (other == EMPTY) {
            return this;
        }
        if (this == EMPTY) {
            return other;
        }
        Capture copy = new Capture();
        if (this.list != null) {
            copy.getList().addAll(this.list);
        }
        if (other.list != null) {
            copy.getList().addAll(other.list);
        }
        return copy;
    }

    public Capture withPrefixedKeys(String prefix) {
        if (this.list == null) {
            return this;
        }
        Capture copy = new Capture();
        for (Map.Entry<String, String> entry : this.list) {
            copy.getList().add(new AbstractMap.SimpleEntry<String, String>(prefix + "/" + entry.getKey(), entry.getValue()));
        }
        return copy;
    }

    public List<String> findValuesByKey(String key) {
        if (this.list == null) {
            return Collections.emptyList();
        }
        return this.list.stream().filter(e -> ((String)e.getKey()).equals(key)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public List<String> getKeysToBeRefactored() {
        return this.list.stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

