/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.plugin.management.internal.InvalidPluginRequestException;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolutionResult;
import org.gradle.plugin.use.resolve.internal.PluginResolver;
import org.gradle.plugin.use.resolve.internal.SimplePluginResolution;

public class CorePluginResolver
implements PluginResolver {
    private final DocumentationRegistry documentationRegistry;
    private final PluginRegistry pluginRegistry;

    public CorePluginResolver(DocumentationRegistry documentationRegistry, PluginRegistry pluginRegistry) {
        this.documentationRegistry = documentationRegistry;
        this.pluginRegistry = pluginRegistry;
    }

    @Override
    public PluginResolutionResult resolve(PluginRequestInternal pluginRequest) {
        PluginId id = pluginRequest.getId();
        if (!CorePluginResolver.isCorePluginRequest(id)) {
            return PluginResolutionResult.notFound(CorePluginResolver.getDescription(), String.format("plugin is not in '%s' namespace", "org.gradle"));
        }
        PluginImplementation plugin = this.pluginRegistry.lookup(id);
        if (plugin == null) {
            return PluginResolutionResult.notFound(CorePluginResolver.getDescription(), "not a core plugin. " + this.documentationRegistry.getDocumentationRecommendationFor("available plugins", "plugin_reference"));
        }
        CorePluginResolver.validate(pluginRequest);
        return PluginResolutionResult.found(new SimplePluginResolution(plugin));
    }

    private static void validate(PluginRequestInternal pluginRequest) {
        if (pluginRequest.getVersion() != null) {
            throw new InvalidPluginRequestException(pluginRequest, CorePluginResolver.getCorePluginClarification(pluginRequest) + "which cannot be specified with a version number. Such plugins are versioned as part of Gradle. Please remove the version number from the declaration.");
        }
        if (pluginRequest.getModule() != null) {
            throw new InvalidPluginRequestException(pluginRequest, CorePluginResolver.getCorePluginClarification(pluginRequest) + "which cannot be specified with a custom implementation artifact. Such plugins are versioned as part of Gradle. Please remove the custom artifact from the request.");
        }
        if (!pluginRequest.isApply()) {
            throw new InvalidPluginRequestException(pluginRequest, CorePluginResolver.getCorePluginClarification(pluginRequest) + "which is already on the classpath. Requesting it with the 'apply false' option is a no-op.");
        }
    }

    private static String getCorePluginClarification(PluginRequestInternal pluginRequest) {
        return "Plugin '" + pluginRequest.getId() + "' is a core Gradle plugin, ";
    }

    private static boolean isCorePluginRequest(PluginId id) {
        String namespace = id.getNamespace();
        return namespace == null || namespace.equals("org.gradle");
    }

    public static String getDescription() {
        return "Gradle Core Plugins";
    }
}

