/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.compile.ApiCompilerResult;
import org.gradle.api.internal.tasks.compile.BaseForkOptionsConverter;
import org.gradle.api.internal.tasks.compile.GroovyCompilerFactory;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.MinimalGroovyCompilerDaemonForkOptions;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompilerDaemonForkOptions;
import org.gradle.api.internal.tasks.compile.daemon.AbstractDaemonCompiler;
import org.gradle.api.internal.tasks.compile.daemon.CompilerWorkerExecutor;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.constants.ConstantsAnalysisResult;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingResult;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.jvm.JpmsConfiguration;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DaemonForkOptionsBuilder;
import org.gradle.workers.internal.HierarchicalClassLoaderStructure;
import org.gradle.workers.internal.KeepAliveMode;

public class DaemonGroovyCompiler
extends AbstractDaemonCompiler<GroovyJavaJointCompileSpec> {
    private static final Iterable<String> SHARED_PACKAGES = Arrays.asList("groovy", "org.codehaus.groovy", "groovyjarjarantlr", "groovyjarjarasm", "groovyjarjarcommonscli", "org.apache.tools.ant", "com.sun.tools.javac");
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final File daemonWorkingDir;
    private final JvmVersionDetector jvmVersionDetector;
    private final InternalProblemReporter problemReporter;

    public DaemonGroovyCompiler(File daemonWorkingDir, ClassPathRegistry classPathRegistry, CompilerWorkerExecutor compilerWorkerExecutor, ClassLoaderRegistry classLoaderRegistry, JavaForkOptionsFactory forkOptionsFactory, JvmVersionDetector jvmVersionDetector, InternalProblemReporter problemReporter) {
        super(compilerWorkerExecutor);
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
        this.forkOptionsFactory = forkOptionsFactory;
        this.daemonWorkingDir = daemonWorkingDir;
        this.jvmVersionDetector = jvmVersionDetector;
        this.problemReporter = problemReporter;
    }

    protected CompilerWorkerExecutor.CompilerParameters getCompilerParameters(GroovyJavaJointCompileSpec spec) {
        return new GroovyCompilerParameters(GroovyCompilerFactory.DaemonSideCompiler.class.getName(), new Object[]{this.classPathRegistry.getClassPath("JAVA-COMPILER-PLUGIN").getAsFiles()}, spec);
    }

    protected Set<Class<?>> getAdditionalCompilerServices() {
        return Collections.emptySet();
    }

    protected DaemonForkOptions toDaemonForkOptions(GroovyJavaJointCompileSpec spec) {
        MinimalJavaCompilerDaemonForkOptions javaOptions = spec.getCompileOptions().getForkOptions();
        MinimalGroovyCompilerDaemonForkOptions groovyOptions = spec.getGroovyCompileOptions().getForkOptions();
        List antFiles = this.classPathRegistry.getClassPath("ANT").getAsFiles();
        Iterable classpath = Iterables.concat((Iterable)spec.getGroovyClasspath(), (Iterable)antFiles);
        VisitableURLClassLoader.Spec targetGroovyClasspath = new VisitableURLClassLoader.Spec("worker-loader", DefaultClassPath.of((Iterable)classpath).getAsURLs());
        ClassPath languageGroovyClasspath = this.classPathRegistry.getClassPath("GROOVY-COMPILER");
        FilteringClassLoader.Spec gradleAndUserFilter = DaemonGroovyCompiler.getMinimalGradleFilter();
        for (String sharedPackage : SHARED_PACKAGES) {
            gradleAndUserFilter.allowPackage(sharedPackage);
        }
        JavaForkOptions javaForkOptions = new BaseForkOptionsConverter(this.forkOptionsFactory).transform(this.mergeForkOptions((BaseForkOptions)javaOptions, (BaseForkOptions)groovyOptions));
        javaForkOptions.setWorkingDir(this.daemonWorkingDir);
        javaForkOptions.setExecutable(javaOptions.getExecutable());
        int javaVersionMajor = this.jvmVersionDetector.getJavaVersionMajor(javaOptions.getExecutable());
        javaForkOptions.jvmArgs((Iterable)JpmsConfiguration.forGroovyProcesses((int)javaVersionMajor));
        if (javaVersionMajor <= 8) {
            File javaExecutable = new File(javaForkOptions.getExecutable());
            JavaInfo jvm = Jvm.forHome((File)javaExecutable.getParentFile().getParentFile());
            File toolsJar = jvm.getToolsJar();
            if (toolsJar == null) {
                String contextualMessage = String.format("The 'tools.jar' cannot be found in the JDK '%s'.", jvm.getJavaHome());
                ProblemId problemId = ProblemId.create((String)"missing-tools-jar", (String)"Missing tools.jar", (ProblemGroup)GradleCoreProblemGroup.compilation().groovy());
                throw this.problemReporter.throwing((Throwable)new IllegalStateException(contextualMessage), problemId, problemSpec -> problemSpec.contextualLabel(contextualMessage).solution("Check if the installation is not a JRE but a JDK.").severity(Severity.ERROR));
            }
            languageGroovyClasspath = languageGroovyClasspath.plus(Collections.singletonList(toolsJar));
        }
        VisitableURLClassLoader.Spec compilerClasspath = new VisitableURLClassLoader.Spec("compiler-loader", languageGroovyClasspath.getAsURLs());
        HierarchicalClassLoaderStructure classLoaderStructure = new HierarchicalClassLoaderStructure((ClassLoaderSpec)this.classLoaderRegistry.getGradleWorkerExtensionSpec()).withChild((ClassLoaderSpec)DaemonGroovyCompiler.getMinimalGradleFilter()).withChild((ClassLoaderSpec)targetGroovyClasspath).withChild((ClassLoaderSpec)gradleAndUserFilter).withChild((ClassLoaderSpec)compilerClasspath);
        return new DaemonForkOptionsBuilder(this.forkOptionsFactory).javaForkOptions(javaForkOptions).keepAliveMode(KeepAliveMode.SESSION).withClassLoaderStructure((ClassLoaderStructure)classLoaderStructure).build();
    }

    private static FilteringClassLoader.Spec getMinimalGradleFilter() {
        FilteringClassLoader.Spec gradleFilterSpec = new FilteringClassLoader.Spec();
        gradleFilterSpec.allowPackage("org.slf4j");
        gradleFilterSpec.allowPackage("net.rubygrapefruit.platform");
        gradleFilterSpec.allowPackage("javax.inject");
        gradleFilterSpec.allowPackage("org.gradle");
        gradleFilterSpec.allowPackage("com.google");
        gradleFilterSpec.disallowPackage("org.gradle.api.internal.tasks.compile");
        gradleFilterSpec.allowClass(ApiCompilerResult.class);
        gradleFilterSpec.allowClass(AnnotationProcessingResult.class);
        gradleFilterSpec.allowClass(ConstantsAnalysisResult.class);
        return gradleFilterSpec;
    }

    public static class GroovyCompilerParameters
    extends CompilerWorkerExecutor.CompilerParameters {
        private final GroovyJavaJointCompileSpec compileSpec;

        public GroovyCompilerParameters(String compilerClassName, Object[] compilerInstanceParameters, GroovyJavaJointCompileSpec compileSpec) {
            super(compilerClassName, compilerInstanceParameters);
            this.compileSpec = compileSpec;
        }

        public GroovyJavaJointCompileSpec getCompileSpec() {
            return this.compileSpec;
        }
    }
}

