/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.file.CaseSensitivity;
import net.rubygrapefruit.platform.file.FileSystemInfo;

public class DefaultFileSystemInfo
implements FileSystemInfo {
    private final File mountPoint;
    private final String fileSystemType;
    private final String deviceName;
    private final boolean remote;
    private final CaseSensitivity caseSensitivity;

    public DefaultFileSystemInfo(File mountPoint, String fileSystemType, String deviceName, boolean remote, @Nullable CaseSensitivity caseSensitivity) {
        this.mountPoint = mountPoint;
        this.fileSystemType = fileSystemType;
        this.deviceName = deviceName;
        this.remote = remote;
        this.caseSensitivity = caseSensitivity;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public File getMountPoint() {
        return this.mountPoint;
    }

    @Override
    public String getFileSystemType() {
        return this.fileSystemType;
    }

    @Override
    @Nullable
    public CaseSensitivity getCaseSensitivity() {
        return this.caseSensitivity;
    }

    @Override
    public boolean isRemote() {
        return this.remote;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.getCaseSensitivityOrThrow().isCaseSensitive();
    }

    @Override
    public boolean isCasePreserving() {
        return this.getCaseSensitivityOrThrow().isCasePreserving();
    }

    private CaseSensitivity getCaseSensitivityOrThrow() {
        if (this.caseSensitivity == null) {
            throw new NativeException("Could get file system attributes for file system at " + this.mountPoint);
        }
        return this.caseSensitivity;
    }

    public String toString() {
        return "FileSystemInfo{mountPoint=" + this.mountPoint + ", fileSystemType='" + this.fileSystemType + '\'' + ", deviceName='" + this.deviceName + '\'' + ", remote=" + this.remote + ", caseSensitivity=" + this.caseSensitivity + '}';
    }
}

