/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.installation;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gradle.internal.UncheckedException;

public class GradleRuntimeShadedJarDetector {
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_FILE_EXTENSION = ".jar";
    public static final String MARKER_FILENAME = "META-INF/.gradle-runtime-shaded";

    private GradleRuntimeShadedJarDetector() {
    }

    public static boolean isLoadedFrom(Class<?> clazz) {
        URL location;
        if (clazz == null) {
            throw new IllegalArgumentException("Need to provide valid class reference");
        }
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource != null && GradleRuntimeShadedJarDetector.isJarUrl(location = codeSource.getLocation())) {
            try {
                return GradleRuntimeShadedJarDetector.findMarkerFileInJar(new File(location.toURI()));
            }
            catch (URISyntaxException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        return false;
    }

    private static boolean isJarUrl(URL location) {
        return location.getProtocol().equals(FILE_PROTOCOL) && location.getPath().endsWith(JAR_FILE_EXTENSION);
    }

    private static boolean findMarkerFileInJar(File jar) {
        boolean bl;
        JarFile jarFile = new JarFile(jar);
        try {
            JarEntry markerFile = jarFile.getJarEntry(MARKER_FILENAME);
            bl = markerFile != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        jarFile.close();
        return bl;
    }
}

