/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.gradle.internal.buildevents.ExceptionContextVisitor;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.util.internal.TreeVisitor;
import org.jspecify.annotations.Nullable;

public class ContextAwareExceptionHandler {
    static void visit(Failure contextAwareException, ExceptionContextVisitor visitor) {
        String location;
        List causes = contextAwareException.getCauses();
        if (!causes.isEmpty()) {
            for (Failure cause : causes) {
                visitor.visitCause(cause);
                ContextAwareExceptionHandler.visitCauses(cause, visitor);
            }
        }
        visitor.endVisiting();
        if (contextAwareException.getOriginal() instanceof LocationAwareException && (location = ((LocationAwareException)((Object)contextAwareException.getOriginal())).getLocation()) != null) {
            visitor.visitLocation(location);
        }
    }

    public static List<Failure> getReportableCauses(Failure failure) {
        final ArrayList<Failure> causes = new ArrayList<Failure>();
        for (Failure cause : failure.getCauses()) {
            ContextAwareExceptionHandler.visitCauses(cause, (TreeVisitor<? super Failure>)new TreeVisitor<Failure>(){

                @Override
                public void node(Failure node) {
                    causes.add(node);
                }
            });
        }
        return causes;
    }

    private static void visitCauses(Failure t, TreeVisitor<? super Failure> visitor) {
        List causes = t.getCauses();
        if (!causes.isEmpty()) {
            visitor.startChildren();
            for (Failure cause : causes) {
                ContextAwareExceptionHandler.visitContextual(cause, visitor);
            }
            visitor.endChildren();
        }
    }

    private static void visitContextual(Failure t, TreeVisitor<? super Failure> visitor) {
        Failure next = ContextAwareExceptionHandler.findNearestContextual(t);
        if (next != null) {
            visitor.node((Failure)next);
            ContextAwareExceptionHandler.visitCauses(next, visitor);
        } else {
            visitor.node((Failure)t);
        }
    }

    private static @Nullable Failure findNearestContextual(@Nullable Failure t) {
        if (t == null) {
            return null;
        }
        if (t.getOriginal().getClass().getAnnotation(Contextual.class) != null || MultiCauseException.class.isAssignableFrom(t.getExceptionType())) {
            return t;
        }
        Optional cause = t.getCauses().stream().findAny();
        return ContextAwareExceptionHandler.findNearestContextual(cause.orElse(null));
    }
}

