/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.BuildStructureOperationProject;
import org.gradle.initialization.LoadProjectsBuildOperationType;
import org.gradle.initialization.NotifyProjectsLoadedBuildOperationType;
import org.gradle.initialization.ProjectsIdentifiedProgressDetails;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.RunnableBuildOperation;

public class NotifyingBuildLoader
implements BuildLoader {
    private static final NotifyProjectsLoadedBuildOperationType.Result PROJECTS_LOADED_OP_RESULT = new NotifyProjectsLoadedBuildOperationType.Result(){};
    private final BuildLoader buildLoader;
    private final BuildOperationRunner buildOperationRunner;
    private final BuildOperationProgressEventEmitter emitter;

    public NotifyingBuildLoader(BuildLoader buildLoader, BuildOperationRunner buildOperationRunner, BuildOperationProgressEventEmitter emitter) {
        this.buildLoader = buildLoader;
        this.buildOperationRunner = buildOperationRunner;
        this.emitter = emitter;
    }

    @Override
    public void load(final SettingsInternal settings, final GradleInternal gradle) {
        final String buildPath = gradle.getIdentityPath().toString();
        this.buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<Void>(){

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)"Load projects").progressDisplayName("Loading projects").details((Object)new LoadProjectsBuildOperationType.Details(){

                    public String getBuildPath() {
                        return buildPath;
                    }
                });
            }

            public Void call(BuildOperationContext context) {
                NotifyingBuildLoader.this.buildLoader.load(settings, gradle);
                BuildStructureOperationProject rootProject = BuildStructureOperationProject.from(gradle.getOwner());
                NotifyingBuildLoader.this.emitter.emitNowForCurrent((Object)new DefaultProjectsIdentifiedProgressDetails(rootProject, buildPath));
                context.setResult((Object)new BuildStructureOperationResult(rootProject, buildPath));
                return null;
            }
        });
        this.buildOperationRunner.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                gradle.getBuildListenerBroadcaster().projectsLoaded((Gradle)gradle);
                context.setResult((Object)PROJECTS_LOADED_OP_RESULT);
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)gradle.contextualize("Notify projectsLoaded listeners")).details((Object)new NotifyProjectsLoadedBuildOperationType.Details(){

                    public String getBuildPath() {
                        return buildPath;
                    }
                });
            }
        });
    }

    private static class DefaultProjectsIdentifiedProgressDetails
    implements ProjectsIdentifiedProgressDetails {
        private final String buildPath;
        private final ProjectsIdentifiedProgressDetails.Project rootProject;

        public DefaultProjectsIdentifiedProgressDetails(ProjectsIdentifiedProgressDetails.Project rootProject, String buildPath) {
            this.buildPath = buildPath;
            this.rootProject = rootProject;
        }

        public String getBuildPath() {
            return this.buildPath;
        }

        public ProjectsIdentifiedProgressDetails.Project getRootProject() {
            return this.rootProject;
        }
    }

    private static class BuildStructureOperationResult
    implements LoadProjectsBuildOperationType.Result {
        private final LoadProjectsBuildOperationType.Result.Project rootProject;
        private final String buildPath;

        public BuildStructureOperationResult(LoadProjectsBuildOperationType.Result.Project rootProject, String buildPath) {
            this.rootProject = rootProject;
            this.buildPath = buildPath;
        }

        public LoadProjectsBuildOperationType.Result.Project getRootProject() {
            return this.rootProject;
        }

        public String getBuildPath() {
            return this.buildPath;
        }
    }
}

