/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration.internal;

import java.util.List;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.gradle.configuration.internal.DynamicCallContextTracker;
import org.jspecify.annotations.NonNull;

public class DefaultDynamicCallContextTracker
implements DynamicCallContextTracker {
    private final ThreadLocal<State> stateByThread = ThreadLocal.withInitial(() -> new State());
    private final List<Consumer<Object>> enterListeners = new CopyOnWriteArrayList<Consumer<Object>>();
    private final List<Consumer<Object>> leaveListeners = new CopyOnWriteArrayList<Consumer<Object>>();

    @Override
    public void enterDynamicCall(@NonNull Object entryPoint) {
        this.currentEntryPointStack().push(entryPoint);
        this.enterListeners.forEach(listener -> listener.accept(entryPoint));
    }

    @Override
    public void leaveDynamicCall(@NonNull Object entryPoint) {
        Stack<Object> entryPointsStack = this.currentEntryPointStack();
        Object top = entryPointsStack.peek();
        if (top != entryPoint) {
            throw new IllegalStateException("Mismatch in leaving dynamic call: leaving " + entryPoint + ", while " + top + " should be left.");
        }
        entryPointsStack.pop();
        this.leaveListeners.forEach(listener -> listener.accept(entryPoint));
    }

    @Override
    public void onEnter(Consumer<Object> listener) {
        this.enterListeners.add(listener);
    }

    @Override
    public void onLeave(Consumer<Object> listener) {
        this.leaveListeners.add(listener);
    }

    private Stack<Object> currentEntryPointStack() {
        return this.stateByThread.get().entryPointsStack;
    }

    private static class State {
        Stack<Object> entryPointsStack = new Stack();

        private State() {
        }
    }
}

