/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.build.NestedRootBuildRunner;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Child Gradle build will do its own caching")
public abstract class GradleBuild
extends ConventionTask {
    private StartParameter startParameter = NestedRootBuildRunner.createStartParameterForNewBuild(this.getServices());
    private String buildName;

    public GradleBuild() {
        this.startParameter.setCurrentDir(this.getProject().getProjectDir());
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    public void setStartParameter(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public File getDir() {
        return this.getStartParameter().getCurrentDir();
    }

    public void setDir(File dir) {
        this.setDir((Object)dir);
    }

    public void setDir(Object dir) {
        this.getStartParameter().setCurrentDir(this.getProject().file(dir));
    }

    @Input
    @ToBeReplacedByLazyProperty
    public List<String> getTasks() {
        return this.getStartParameter().getTaskNames();
    }

    public void setTasks(List<String> tasks) {
        this.setTasks((Collection<String>)tasks);
    }

    public void setTasks(Collection<String> tasks) {
        this.getStartParameter().setTaskNames(tasks);
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public String getBuildName() {
        return this.buildName;
    }

    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    @TaskAction
    void build() {
        StartParameterInternal startParameter = (StartParameterInternal)this.getStartParameter();
        GradleBuild.nagForNonStringProjectProperties(startParameter.getProjectPropertiesUntracked());
        NestedRootBuildRunner.runNestedRootBuild(this.buildName, startParameter, this.getServices());
    }

    private static void nagForNonStringProjectProperties(Map<String, String> projectProperties) {
        for (Map.Entry<String, String> entry : projectProperties.entrySet()) {
            String propertyName = entry.getKey();
            String propertyValue = entry.getValue();
            if (propertyValue instanceof String) continue;
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)String.format("Using non-String project properties: property '%s' has value of type %s.", propertyName, propertyValue.getClass().getName())).willBecomeAnErrorInGradle10().withUpgradeGuideSection(9, "deprecated-gradle-build-non-string-properties")).nagUser();
            return;
        }
    }
}

