/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.ImmutableSet;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.TaskReference;
import org.gradle.util.Path;

public class DefaultTaskReference
implements TaskReference,
TaskDependencyContainer {
    private final String taskName;
    private final TaskDependencyContainer taskDependency;

    private DefaultTaskReference(String taskName, TaskDependencyContainer taskDependency) {
        this.taskName = taskName;
        this.taskDependency = taskDependency;
    }

    public String getName() {
        return this.taskName;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add((Object)this.taskDependency);
    }

    public static TaskReference create(String pathStr, TaskDependencyFactory taskDependencyFactory) {
        Path path = Path.path((String)pathStr);
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Task path '%s' is not a qualified task path (e.g. ':task' or ':project:task').", pathStr));
        }
        String taskName = path.getName();
        if (taskName == null) {
            assert (path == Path.ROOT);
            throw new IllegalArgumentException("The root path is not a valid task path");
        }
        DefaultTaskDependency taskDependency = taskDependencyFactory.configurableDependency(ImmutableSet.of((Object)pathStr));
        return new DefaultTaskReference(taskName, (TaskDependencyContainer)taskDependency);
    }
}

