/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.ResolutionProvider;

@Contextual
public final class VariantTransformConfigurationException
extends GradleException
implements ResolutionProvider {
    private static final String RUN_REPORT_SUGGESTION = "Run the 'artifactTransforms' report task to view details about registered transforms.";
    private final List<String> resolutions;

    public VariantTransformConfigurationException(String message, Throwable cause, DocumentationRegistry documentationRegistry) {
        super(message, cause);
        this.resolutions = VariantTransformConfigurationException.buildResolutions(documentationRegistry);
    }

    public VariantTransformConfigurationException(String message, DocumentationRegistry documentationRegistry) {
        super(message);
        this.resolutions = VariantTransformConfigurationException.buildResolutions(documentationRegistry);
    }

    private static List<String> buildResolutions(DocumentationRegistry documentationRegistry) {
        return Arrays.asList(RUN_REPORT_SUGGESTION, "Review the documentation on Artifact Transforms at " + documentationRegistry.getDocumentationFor("artifact_transforms") + ".");
    }

    public List<String> getResolutions() {
        return this.resolutions;
    }
}

