/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.versionedcache;

import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.gradle.internal.versionedcache.VersionSpecificCacheDirectory;
import org.gradle.util.GradleVersion;
import org.jspecify.annotations.Nullable;

public class VersionSpecificCacheDirectoryScanner {
    private final File baseDir;

    public VersionSpecificCacheDirectoryScanner(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getDirectory(GradleVersion gradleVersion) {
        return new File(this.baseDir, gradleVersion.getVersion());
    }

    public SortedSet<VersionSpecificCacheDirectory> getExistingDirectories() {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (File subDir : this.listVersionSpecificCacheDirs()) {
            GradleVersion version = this.tryParseGradleVersion(subDir);
            if (version == null) continue;
            builder.add((Object)new VersionSpecificCacheDirectory(subDir, version));
        }
        return builder.build();
    }

    private Collection<File> listVersionSpecificCacheDirs() {
        IOFileFilter combinedFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), new RegexFileFilter("^\\d.*")});
        File[] result = this.baseDir.listFiles((FileFilter)combinedFilter);
        return result == null ? Collections.emptySet() : Arrays.asList(result);
    }

    private @Nullable GradleVersion tryParseGradleVersion(File dir) {
        try {
            return GradleVersion.version((String)dir.getName());
        }
        catch (Exception e) {
            return null;
        }
    }
}

