/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.FilteringProvider;
import org.gradle.api.internal.provider.FlatMapProvider;
import org.gradle.api.internal.provider.ManagedFactories;
import org.gradle.api.internal.provider.MappingProvider;
import org.gradle.api.internal.provider.MissingValueException;
import org.gradle.api.internal.provider.OrElseFixedValueProvider;
import org.gradle.api.internal.provider.OrElseProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.TransformBackedProvider;
import org.gradle.api.internal.provider.TypeSanitizingTransformer;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.evaluation.EvaluationContext;
import org.gradle.internal.evaluation.EvaluationOwner;
import org.gradle.internal.evaluation.EvaluationScopeContext;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.state.Managed;
import org.jspecify.annotations.Nullable;

public abstract class AbstractMinimalProvider<T>
implements ProviderInternal<T>,
Managed {
    private static final DisplayName DEFAULT_DISPLAY_NAME = Describables.of((Object)"this provider");

    @Override
    public <S> ProviderInternal<S> map(Transformer<? extends @Nullable S, ? super T> transformer) {
        return new TransformBackedProvider<S, T>(null, this, transformer);
    }

    public ProviderInternal<T> filter(Spec<? super T> spec) {
        return new FilteringProvider<T>(this, spec);
    }

    public <S> Provider<S> flatMap(Transformer<? extends @Nullable Provider<? extends S>, ? super T> transformer) {
        return new FlatMapProvider(this, transformer);
    }

    protected @Nullable DisplayName getDeclaredDisplayName() {
        return null;
    }

    protected DisplayName getDisplayName() {
        DisplayName displayName = this.getDeclaredDisplayName();
        if (displayName == null) {
            return DEFAULT_DISPLAY_NAME;
        }
        return displayName;
    }

    protected DisplayName getTypedDisplayName() {
        return DEFAULT_DISPLAY_NAME;
    }

    protected abstract ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer var1);

    protected ValueSupplier.Value<? extends T> calculateOwnPresentValue() {
        ValueSupplier.Value<T> value = this.calculateOwnValue(ValueSupplier.ValueConsumer.IgnoreUnsafeRead);
        if (value.isMissing()) {
            throw new MissingValueException(this.cannotQueryValueOf(value));
        }
        return value;
    }

    public boolean isPresent() {
        return this.calculatePresence(ValueSupplier.ValueConsumer.IgnoreUnsafeRead);
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        return !this.calculateOwnValue(consumer).isMissing();
    }

    @Override
    public T get() {
        return this.calculateOwnPresentValue().get();
    }

    public T getOrNull() {
        return this.calculateOwnValue(ValueSupplier.ValueConsumer.IgnoreUnsafeRead).orNull();
    }

    public T getOrElse(T defaultValue) {
        return (T)this.calculateOwnValue(ValueSupplier.ValueConsumer.IgnoreUnsafeRead).orElse(Cast.uncheckedNonnullCast(defaultValue));
    }

    @Override
    public ValueSupplier.Value<? extends T> calculateValue(ValueSupplier.ValueConsumer consumer) {
        return this.calculateOwnValue(consumer).pushWhenMissing(this.getDeclaredDisplayName());
    }

    public Provider<T> orElse(T value) {
        return new OrElseFixedValueProvider<T>(this, value);
    }

    public Provider<T> orElse(Provider<? extends T> provider) {
        return new OrElseProvider<T>(this, Providers.internal(provider));
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.getProducer().visitDependencies(context);
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return ValueSupplier.ValueProducer.unknown();
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        return ValueSupplier.ExecutionTimeValue.value(this.calculateOwnValue(ValueSupplier.ValueConsumer.IgnoreUnsafeRead));
    }

    @Override
    public ProviderInternal<T> asSupplier(DisplayName owner, Class<? super T> targetType, ValueSanitizer<? super T> sanitizer) {
        Class selfType = this.getType();
        if (selfType != null && !targetType.isAssignableFrom(selfType)) {
            throw new IllegalArgumentException(AbstractMinimalProvider.formatInvalidTypeException(owner.getDisplayName(), targetType, selfType));
        }
        if (selfType == null) {
            return new MappingProvider((Class)Cast.uncheckedCast(targetType), this, new TypeSanitizingTransformer<T>(owner, sanitizer, targetType));
        }
        return this;
    }

    private static String formatInvalidTypeException(String owner, Class<?> targetType, Class<?> selfType) {
        String selfTypeName;
        String targetTypeName = targetType.getName();
        if (targetTypeName.equals(selfTypeName = selfType.getName())) {
            targetTypeName = targetTypeName + " loaded with " + targetType.getClassLoader();
            selfTypeName = selfTypeName + " loaded with " + selfType.getClassLoader();
        }
        return String.format("Cannot set the value of %s of type %s using a provider of type %s.", owner, targetTypeName, selfTypeName);
    }

    @Override
    public ProviderInternal<T> withFinalValue(ValueSupplier.ValueConsumer consumer) {
        return Providers.nullableValue(this.calculateValue(consumer));
    }

    public final String toString() {
        return (String)EvaluationContext.current().tryEvaluate((EvaluationOwner)this, (Object)"<CIRCULAR REFERENCE>", this::toStringNoReentrance);
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public Class<?> publicType() {
        return Provider.class;
    }

    @Override
    public Object unpackState() {
        return this.getOrNull();
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.ProviderManagedFactory.FACTORY_ID;
    }

    private String cannotQueryValueOf(ValueSupplier.Value<? extends T> value) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Cannot query the value of ").append((CharSequence)this.getDisplayName().getDisplayName()).append((CharSequence)" because it has no value available.");
        if (!value.getPathToOrigin().isEmpty()) {
            formatter.node("The value of ").append((CharSequence)this.getTypedDisplayName().getDisplayName()).append((CharSequence)" is derived from");
            formatter.startChildren();
            for (DisplayName displayName : value.getPathToOrigin()) {
                formatter.node(displayName.getDisplayName());
            }
            formatter.endChildren();
        }
        return formatter.toString();
    }

    protected EvaluationScopeContext openScope() {
        return EvaluationContext.current().open((EvaluationOwner)this);
    }

    protected String toStringNoReentrance() {
        Class type = this.getType();
        return String.format("provider(%s)", type == null ? "?" : type.getName());
    }
}

