/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.gradle.internal.Cast;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.component.model.ModuleSources;
import org.jspecify.annotations.Nullable;

public class MutableModuleSources
implements ModuleSources {
    private List<ModuleSource> moduleSources;

    public static MutableModuleSources of(@Nullable ModuleSource source) {
        MutableModuleSources sources = new MutableModuleSources();
        if (source != null) {
            sources.add(source);
        }
        return sources;
    }

    public static MutableModuleSources of(ModuleSources sources) {
        if (sources instanceof MutableModuleSources) {
            return (MutableModuleSources)sources;
        }
        MutableModuleSources mutableModuleSources = new MutableModuleSources();
        if (sources == null) {
            return mutableModuleSources;
        }
        sources.withSources(mutableModuleSources::add);
        return mutableModuleSources;
    }

    @Override
    public <T extends ModuleSource> Optional<T> getSource(Class<T> sourceType) {
        if (this.moduleSources == null) {
            return Optional.empty();
        }
        return (Optional)Cast.uncheckedCast(this.moduleSources.stream().filter(src -> sourceType.isAssignableFrom(src.getClass())).findFirst());
    }

    @Override
    public void withSources(Consumer<ModuleSource> consumer) {
        if (this.moduleSources != null) {
            this.moduleSources.forEach(consumer);
        }
    }

    @Override
    public int size() {
        return this.moduleSources == null ? 0 : this.moduleSources.size();
    }

    public void add(ModuleSource source) {
        assert (source != null);
        this.maybeCreateStore();
        this.moduleSources.add(source);
    }

    private void maybeCreateStore() {
        if (this.moduleSources == null) {
            this.moduleSources = new ArrayList<ModuleSource>(2);
        }
    }

    ImmutableModuleSources asImmutable() {
        if (this.moduleSources == null) {
            return ImmutableModuleSources.of();
        }
        return ImmutableModuleSources.of(this.moduleSources.toArray(new ModuleSource[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableModuleSources that = (MutableModuleSources)o;
        return Objects.equals(this.moduleSources, that.moduleSources);
    }

    public int hashCode() {
        return this.moduleSources != null ? this.moduleSources.hashCode() : 0;
    }
}

