/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.capability.DefaultSpecificCapabilitySelector;
import org.gradle.api.internal.artifacts.capability.FeatureCapabilitySelector;
import org.gradle.api.internal.artifacts.capability.SpecificCapabilitySelector;
import org.gradle.api.internal.artifacts.component.ComponentSelectorInternal;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;

public class DefaultModuleComponentSelector
implements ModuleComponentSelector,
ComponentSelectorInternal {
    private final ModuleIdentifier moduleIdentifier;
    private final ImmutableVersionConstraint versionConstraint;
    private final ImmutableAttributes attributes;
    private final ImmutableSet<CapabilitySelector> capabilitySelectors;
    private final int hashCode;

    private DefaultModuleComponentSelector(ModuleIdentifier module, ImmutableVersionConstraint version, ImmutableAttributes attributes, ImmutableSet<CapabilitySelector> capabilitySelectors) {
        this.moduleIdentifier = module;
        this.versionConstraint = version;
        this.attributes = attributes;
        this.capabilitySelectors = capabilitySelectors;
        this.hashCode = this.computeHashcode(module, version, attributes, capabilitySelectors);
    }

    private int computeHashcode(ModuleIdentifier module, ImmutableVersionConstraint version, ImmutableAttributes attributes, ImmutableSet<CapabilitySelector> capabilitySelectors) {
        int hashCode = version.hashCode();
        hashCode = 31 * hashCode + module.hashCode();
        hashCode = 31 * hashCode + attributes.hashCode();
        hashCode = 31 * hashCode + capabilitySelectors.hashCode();
        return hashCode;
    }

    public String getDisplayName() {
        String group = this.moduleIdentifier.getGroup();
        String module = this.moduleIdentifier.getName();
        StringBuilder builder = new StringBuilder(group.length() + module.length() + this.versionConstraint.getRequiredVersion().length() + 2);
        builder.append(group);
        builder.append(":");
        builder.append(module);
        String versionString = this.versionConstraint.getDisplayName();
        if (versionString.length() > 0) {
            builder.append(":");
            builder.append(versionString);
        }
        return builder.toString();
    }

    public String getGroup() {
        return this.moduleIdentifier.getGroup();
    }

    public String getModule() {
        return this.moduleIdentifier.getName();
    }

    public String getVersion() {
        return this.versionConstraint.getRequiredVersion();
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public List<Capability> getRequestedCapabilities() {
        return (List)this.capabilitySelectors.stream().map(c -> {
            if (c instanceof SpecificCapabilitySelector) {
                return ((DefaultSpecificCapabilitySelector)c).getBackingCapability();
            }
            if (c instanceof FeatureCapabilitySelector) {
                return new DefaultImmutableCapability(this.getGroup(), this.getModule() + "-" + ((FeatureCapabilitySelector)c).getFeatureName(), this.getVersion());
            }
            throw new UnsupportedOperationException("Unsupported capability selector type: " + c.getClass().getName());
        }).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ImmutableSet<CapabilitySelector> getCapabilitySelectors() {
        return this.capabilitySelectors;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.attributes;
    }

    public boolean matchesStrictly(ComponentIdentifier identifier) {
        if (identifier instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)identifier;
            return this.moduleIdentifier.getName().equals(moduleComponentIdentifier.getModule()) && this.moduleIdentifier.getGroup().equals(moduleComponentIdentifier.getGroup()) && this.getVersion().equals(moduleComponentIdentifier.getVersion());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleComponentSelector that = (DefaultModuleComponentSelector)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        if (!this.moduleIdentifier.equals(that.moduleIdentifier)) {
            return false;
        }
        if (!this.versionConstraint.equals(that.versionConstraint)) {
            return false;
        }
        if (!this.attributes.equals(that.attributes)) {
            return false;
        }
        return this.capabilitySelectors.equals(that.capabilitySelectors);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ModuleComponentSelector newSelector(ModuleIdentifier id, VersionConstraint version, AttributeContainer attributes, Set<CapabilitySelector> capabilitySelectors) {
        return new DefaultModuleComponentSelector(id, DefaultImmutableVersionConstraint.of(version), ((AttributeContainerInternal)attributes).asImmutable(), (ImmutableSet<CapabilitySelector>)ImmutableSet.copyOf(capabilitySelectors));
    }

    public static ModuleComponentSelector newSelector(ModuleIdentifier id, VersionConstraint version) {
        return new DefaultModuleComponentSelector(id, DefaultImmutableVersionConstraint.of(version), ImmutableAttributes.EMPTY, (ImmutableSet<CapabilitySelector>)ImmutableSet.of());
    }

    public static ModuleComponentSelector newSelector(ModuleIdentifier id, String version) {
        return new DefaultModuleComponentSelector(id, DefaultImmutableVersionConstraint.of(version), ImmutableAttributes.EMPTY, (ImmutableSet<CapabilitySelector>)ImmutableSet.of());
    }

    public static ModuleComponentSelector newSelector(ModuleVersionSelector selector) {
        return new DefaultModuleComponentSelector(selector.getModule(), DefaultImmutableVersionConstraint.of(selector.getVersion()), ImmutableAttributes.EMPTY, (ImmutableSet<CapabilitySelector>)ImmutableSet.of());
    }

    public static ModuleComponentSelector withAttributes(ModuleComponentSelector selector, ImmutableAttributes attributes) {
        DefaultModuleComponentSelector cs = (DefaultModuleComponentSelector)selector;
        return new DefaultModuleComponentSelector(cs.moduleIdentifier, cs.versionConstraint, attributes, cs.capabilitySelectors);
    }

    public static ComponentSelector withCapabilities(ModuleComponentSelector selector, ImmutableSet<CapabilitySelector> capabilitySelectors) {
        DefaultModuleComponentSelector cs = (DefaultModuleComponentSelector)selector;
        return new DefaultModuleComponentSelector(cs.moduleIdentifier, cs.versionConstraint, cs.attributes, (ImmutableSet<CapabilitySelector>)ImmutableSet.copyOf(capabilitySelectors));
    }
}

