/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import org.gradle.cache.FileLock;
import org.gradle.cache.internal.filelock.LockState;
import org.gradle.cache.internal.filelock.LockStateSerializer;

public class DefaultLockStateSerializer
implements LockStateSerializer {
    @Override
    public int getSize() {
        return 16;
    }

    @Override
    public byte getVersion() {
        return 3;
    }

    @Override
    public LockState createInitialState() {
        long creationNumber = new Random().nextLong();
        return new SequenceNumberLockState(creationNumber, -1L, 0L);
    }

    @Override
    public void write(DataOutput dataOutput, LockState lockState) throws IOException {
        SequenceNumberLockState state = (SequenceNumberLockState)lockState;
        dataOutput.writeLong(state.creationNumber);
        dataOutput.writeLong(state.sequenceNumber);
    }

    @Override
    public LockState read(DataInput dataInput) throws IOException {
        long creationNumber = dataInput.readLong();
        long sequenceNumber = dataInput.readLong();
        return new SequenceNumberLockState(creationNumber, sequenceNumber, sequenceNumber);
    }

    private static class SequenceNumberLockState
    implements LockState {
        private final long creationNumber;
        private final long originalSequenceNumber;
        private final long sequenceNumber;

        private SequenceNumberLockState(long creationNumber, long originalSequenceNumber, long sequenceNumber) {
            this.creationNumber = creationNumber;
            this.originalSequenceNumber = originalSequenceNumber;
            this.sequenceNumber = sequenceNumber;
        }

        public String toString() {
            return String.format("[%s,%s,%s]", this.creationNumber, this.sequenceNumber, this.isDirty());
        }

        @Override
        public LockState beforeUpdate() {
            return new SequenceNumberLockState(this.creationNumber, this.originalSequenceNumber, 0L);
        }

        @Override
        public LockState completeUpdate() {
            long newSequenceNumber = this.isInInitialState() ? 1L : this.originalSequenceNumber + 1L;
            return new SequenceNumberLockState(this.creationNumber, newSequenceNumber, newSequenceNumber);
        }

        @Override
        public boolean isDirty() {
            return this.sequenceNumber == 0L || this.sequenceNumber != this.originalSequenceNumber;
        }

        @Override
        public boolean canDetectChanges() {
            return true;
        }

        @Override
        public boolean isInInitialState() {
            return this.originalSequenceNumber <= 0L;
        }

        @Override
        public boolean hasBeenUpdatedSince(FileLock.State state) {
            SequenceNumberLockState other = (SequenceNumberLockState)state;
            return this.sequenceNumber != other.sequenceNumber || this.creationNumber != other.creationNumber;
        }
    }
}

