﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/snow-device-management/SnowDeviceManagementRequest.h>
#include <aws/snow-device-management/SnowDeviceManagement_EXPORTS.h>

#include <utility>

namespace Aws {
namespace SnowDeviceManagement {
namespace Model {

/**
 */
class CancelTaskRequest : public SnowDeviceManagementRequest {
 public:
  AWS_SNOWDEVICEMANAGEMENT_API CancelTaskRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CancelTask"; }

  AWS_SNOWDEVICEMANAGEMENT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ID of the task that you are attempting to cancel. You can retrieve a task
   * ID by using the <code>ListTasks</code> operation.</p>
   */
  inline const Aws::String& GetTaskId() const { return m_taskId; }
  inline bool TaskIdHasBeenSet() const { return m_taskIdHasBeenSet; }
  template <typename TaskIdT = Aws::String>
  void SetTaskId(TaskIdT&& value) {
    m_taskIdHasBeenSet = true;
    m_taskId = std::forward<TaskIdT>(value);
  }
  template <typename TaskIdT = Aws::String>
  CancelTaskRequest& WithTaskId(TaskIdT&& value) {
    SetTaskId(std::forward<TaskIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_taskId;
  bool m_taskIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SnowDeviceManagement
}  // namespace Aws
