﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/iot/IoTRequest.h>
#include <aws/iot/IoT_EXPORTS.h>

#include <utility>

namespace Aws {
namespace IoT {
namespace Model {

/**
 */
class UpdateDimensionRequest : public IoTRequest {
 public:
  AWS_IOT_API UpdateDimensionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateDimension"; }

  AWS_IOT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>A unique identifier for the dimension. Choose something that describes the
   * type and value to make it easy to remember what it does.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateDimensionRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies the value or list of values for the dimension. For
   * <code>TOPIC_FILTER</code> dimensions, this is a pattern used to match the MQTT
   * topic (for example, "admin/#").</p>
   */
  inline const Aws::Vector<Aws::String>& GetStringValues() const { return m_stringValues; }
  inline bool StringValuesHasBeenSet() const { return m_stringValuesHasBeenSet; }
  template <typename StringValuesT = Aws::Vector<Aws::String>>
  void SetStringValues(StringValuesT&& value) {
    m_stringValuesHasBeenSet = true;
    m_stringValues = std::forward<StringValuesT>(value);
  }
  template <typename StringValuesT = Aws::Vector<Aws::String>>
  UpdateDimensionRequest& WithStringValues(StringValuesT&& value) {
    SetStringValues(std::forward<StringValuesT>(value));
    return *this;
  }
  template <typename StringValuesT = Aws::String>
  UpdateDimensionRequest& AddStringValues(StringValuesT&& value) {
    m_stringValuesHasBeenSet = true;
    m_stringValues.emplace_back(std::forward<StringValuesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::Vector<Aws::String> m_stringValues;
  bool m_nameHasBeenSet = false;
  bool m_stringValuesHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
