﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/controltower/ControlTower_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ControlTower {
namespace Model {
class UpdateEnabledBaselineResult {
 public:
  AWS_CONTROLTOWER_API UpdateEnabledBaselineResult() = default;
  AWS_CONTROLTOWER_API UpdateEnabledBaselineResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CONTROLTOWER_API UpdateEnabledBaselineResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ID (in UUID format) of the asynchronous
   * <code>UpdateEnabledBaseline</code> operation. This
   * <code>operationIdentifier</code> is used to track status through calls to the
   * <code>GetBaselineOperation</code> API.</p>
   */
  inline const Aws::String& GetOperationIdentifier() const { return m_operationIdentifier; }
  template <typename OperationIdentifierT = Aws::String>
  void SetOperationIdentifier(OperationIdentifierT&& value) {
    m_operationIdentifierHasBeenSet = true;
    m_operationIdentifier = std::forward<OperationIdentifierT>(value);
  }
  template <typename OperationIdentifierT = Aws::String>
  UpdateEnabledBaselineResult& WithOperationIdentifier(OperationIdentifierT&& value) {
    SetOperationIdentifier(std::forward<OperationIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateEnabledBaselineResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_operationIdentifier;
  bool m_operationIdentifierHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ControlTower
}  // namespace Aws
