/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.WinFlatEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.WinFlatUtils;

public class WinFlatEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static final int ICON_X_PAD = 4;
    private final Color background = UIManager.getColor("EditorTab.background");
    private final Color activeBackground = WinFlatUtils.Utils.getUIColor("EditorTab.activeBackground", this.background);
    private final Color contentBorderColor = UIManager.getColor("TabbedContainer.editor.contentBorderColor");
    private final boolean unscaledBorders = WinFlatUtils.Utils.getUIBoolean("EditorTab.unscaledBorders", false);
    private final Insets tabInsets = WinFlatUtils.UIScale.scale(UIManager.getInsets("EditorTab.tabInsets"));

    public WinFlatEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WinFlatEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    @Override
    protected TabCellRenderer createDefaultRenderer() {
        return new WinFlatEditorTabCellRenderer();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Graphics2D graphics2D = BasicScrollingTabDisplayerUI.getOffscreenGraphics(jComponent);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
        Insets insets = this.getTabAreaInsets();
        int n = Math.max(fontMetrics.getHeight(), 16) + insets.top + insets.bottom + this.tabInsets.top + this.tabInsets.bottom;
        return new Dimension(this.displayer.getWidth(), n);
    }

    @Override
    public TabCellRenderer getTabCellRenderer(int n) {
        TabCellRenderer tabCellRenderer = super.getTabCellRenderer(n);
        if (tabCellRenderer instanceof WinFlatEditorTabCellRenderer) {
            WinFlatEditorTabCellRenderer winFlatEditorTabCellRenderer = (WinFlatEditorTabCellRenderer)tabCellRenderer;
            int n2 = this.displayer.getModel().size();
            winFlatEditorTabCellRenderer.firstTab = n == 0;
            winFlatEditorTabCellRenderer.lastTab = n == n2 - 1;
            winFlatEditorTabCellRenderer.nextTabSelected = n + 1 < n2 && (this.tabState.getState(n + 1) & 0x10) != 0;
        }
        return tabCellRenderer;
    }

    @Override
    public Insets getTabAreaInsets() {
        return new Insets(0, 0, 0, this.getControlButtons().getPreferredSize().width + 4);
    }

    @Override
    protected Rectangle getControlButtonsRectangle(Container container) {
        Component component = this.getControlButtons();
        return new Rectangle(container.getWidth() - component.getWidth() - 4, (container.getHeight() - component.getHeight()) / 2, component.getWidth(), component.getHeight());
    }

    @Override
    public void paintBackground(Graphics graphics) {
        int n = this.displayer.getWidth();
        int n2 = this.displayer.getHeight();
        WinFlatUtils.HiDPIUtils.paintAtScale1x(graphics, 0, 0, n, n2, this::paintBackgroundAtScale1x);
    }

    private void paintBackgroundAtScale1x(Graphics2D graphics2D, int n, int n2, double d) {
        graphics2D.setColor(this.displayer.isActive() ? this.activeBackground : this.background);
        graphics2D.fillRect(0, 0, n, n2);
        int n3 = this.unscaledBorders ? 1 : WinFlatUtils.HiDPIUtils.deviceBorderWidth(d, 1);
        graphics2D.setColor(this.contentBorderColor);
        graphics2D.fillRect(0, n2 - n3, n, n3);
    }

    @Override
    public Icon getButtonIcon(int n, int n2) {
        Icon icon = WinFlatUtils.FlatTabControlIcon.get(n, n2);
        return icon != null ? icon : super.getButtonIcon(n, n2);
    }
}

