/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j;

import dev.ai4j.openai4j.LogLevel;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestLoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(RequestLoggingInterceptor.class);
    private static final Set<String> COMMON_SECRET_HEADERS = new HashSet<String>(Arrays.asList("authorization", "x-api-key", "x-auth-token"));
    private static final String BEARER = "Bearer";
    private LogLevel logLevel = LogLevel.DEBUG;

    public RequestLoggingInterceptor() {
    }

    public RequestLoggingInterceptor(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        this.log(request);
        return chain.proceed(request);
    }

    private void log(Request request) {
        String message = "Request:\n- method: {}\n- url: {}\n- headers: {}\n- body: {}";
        try {
            switch (this.logLevel) {
                case INFO: {
                    this.logInfo(request, message);
                    break;
                }
                case WARN: {
                    this.logWarn(request, message);
                    break;
                }
                case ERROR: {
                    this.logError(request, message);
                    break;
                }
                default: {
                    this.logDebug(request, message);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to log request", (Throwable)e);
        }
    }

    private void logInfo(Request request, String message) {
        log.info(message, new Object[]{request.method(), request.url(), RequestLoggingInterceptor.inOneLine(request.headers()), RequestLoggingInterceptor.getBody(request)});
    }

    private void logWarn(Request request, String message) {
        log.warn(message, new Object[]{request.method(), request.url(), RequestLoggingInterceptor.inOneLine(request.headers()), RequestLoggingInterceptor.getBody(request)});
    }

    private void logError(Request request, String message) {
        log.error(message, new Object[]{request.method(), request.url(), RequestLoggingInterceptor.inOneLine(request.headers()), RequestLoggingInterceptor.getBody(request)});
    }

    private void logDebug(Request request, String message) {
        log.debug(message, new Object[]{request.method(), request.url(), RequestLoggingInterceptor.inOneLine(request.headers()), RequestLoggingInterceptor.getBody(request)});
    }

    static String inOneLine(Headers headers) {
        return StreamSupport.stream(headers.spliterator(), false).map(header -> RequestLoggingInterceptor.format((String)header.component1(), (String)header.component2())).collect(Collectors.joining(", "));
    }

    static String format(String headerKey, String headerValue) {
        if (COMMON_SECRET_HEADERS.contains(headerKey.toLowerCase())) {
            headerValue = RequestLoggingInterceptor.maskSecretKey(headerValue);
        }
        return String.format("[%s: %s]", headerKey, headerValue);
    }

    static String maskSecretKey(String key) {
        if (key == null || key.trim().isEmpty()) {
            return key;
        }
        try {
            if (key.startsWith(BEARER)) {
                return "Bearer " + RequestLoggingInterceptor.mask(key.substring(BEARER.length() + 1));
            }
            return RequestLoggingInterceptor.mask(key);
        }
        catch (Exception e) {
            return "Failed to mask the API key.";
        }
    }

    private static String mask(String key) {
        if (key.length() >= 7) {
            return key.substring(0, 5) + "..." + key.substring(key.length() - 2);
        }
        return "...";
    }

    private static String getBody(Request request) {
        try {
            Buffer buffer = new Buffer();
            request.body().writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (Exception e) {
            log.warn("Exception happened while reading request body", (Throwable)e);
            return "[Exception happened while reading request body. Check logs for more details.]";
        }
    }
}

