/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.facet;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.solr.analytics.function.ExpressionCalculator;
import org.apache.solr.analytics.function.ReductionCollectionManager;
import org.apache.solr.common.util.NamedList;

public abstract class AnalyticsFacet {
    protected final Map<String, ReductionCollectionManager.ReductionDataCollection> reductionData = new LinkedHashMap<String, ReductionCollectionManager.ReductionDataCollection>();
    protected ReductionCollectionManager collectionManager;
    protected ExpressionCalculator expressionCalculator;
    protected final String name;

    public AnalyticsFacet(String name) {
        this.name = name;
    }

    public void setReductionCollectionManager(ReductionCollectionManager collectionManager) {
        this.collectionManager = collectionManager;
    }

    public void setExpressionCalculator(ExpressionCalculator expressionCalculator) {
        this.expressionCalculator = expressionCalculator;
    }

    public void importShardData(DataInput input) throws IOException {
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            this.importFacetValue(input, input.readUTF());
        }
    }

    protected void importFacetValue(DataInput input, String facetValue) throws IOException {
        ReductionCollectionManager.ReductionDataCollection dataCollection = this.reductionData.get(facetValue);
        if (dataCollection == null) {
            this.reductionData.put(facetValue, this.collectionManager.newDataCollectionIO());
        } else {
            this.collectionManager.prepareReductionDataIO(dataCollection);
        }
        this.collectionManager.mergeData();
    }

    public void exportShardData(DataOutput output) throws IOException {
        output.writeInt(this.reductionData.size());
        for (String facetValue : this.reductionData.keySet()) {
            this.exportFacetValue(output, facetValue);
        }
    }

    protected void exportFacetValue(DataOutput output, String facetValue) throws IOException {
        output.writeUTF(facetValue);
        this.collectionManager.prepareReductionDataIO(this.reductionData.get(facetValue));
        this.collectionManager.exportData();
    }

    public NamedList<Object> createOldResponse() {
        NamedList nl = new NamedList();
        this.reductionData.forEach((facetVal, dataCol) -> {
            this.collectionManager.setData((ReductionCollectionManager.ReductionDataCollection)dataCol);
            nl.add(facetVal, (Object)new NamedList(this.expressionCalculator.getResults()));
        });
        return nl;
    }

    public Iterable<Map<String, Object>> createResponse() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.reductionData.forEach((facetVal, dataCol) -> {
            HashMap<String, Object> bucket = new HashMap<String, Object>();
            bucket.put("value", facetVal);
            this.collectionManager.setData((ReductionCollectionManager.ReductionDataCollection)dataCol);
            this.expressionCalculator.addResults(bucket);
            list.add(bucket);
        });
        return list;
    }

    public String getName() {
        return this.name;
    }
}

