/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.filestore;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.Utils;

public class FileStoreAPI {
    public static final String KEYS_DIR = "/_trusted_/keys";

    public static class MetaData
    implements MapWriter {
        public static final String SHA512 = "sha512";
        String sha512;
        List<String> signatures;
        Map<String, Object> otherAttribs;

        public MetaData(Map<String, Object> m) {
            m = Utils.getDeepCopy(m, (int)3);
            this.sha512 = (String)m.remove(SHA512);
            this.signatures = (List)m.remove("sig");
            this.otherAttribs = m;
        }

        public void writeMap(MapWriter.EntryWriter ew) throws IOException {
            ew.putIfNotNull((CharSequence)SHA512, (Object)this.sha512);
            ew.putIfNotNull((CharSequence)"sig", this.signatures);
            if (!this.otherAttribs.isEmpty()) {
                this.otherAttribs.forEach(ew.getBiConsumer());
            }
        }

        public int hashCode() {
            return this.sha512.hashCode();
        }

        public boolean equals(Object that) {
            if (that instanceof MetaData) {
                MetaData metaData = (MetaData)that;
                return Objects.equals(this.sha512, metaData.sha512) && Objects.equals(this.signatures, metaData.signatures) && Objects.equals(this.otherAttribs, metaData.otherAttribs);
            }
            return false;
        }
    }
}

