/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.message;

import net.sf.sdedit.Constants;
import net.sf.sdedit.config.SequenceConfiguration;
import net.sf.sdedit.diagram.Lifeline;
import net.sf.sdedit.diagram.MessageData;
import net.sf.sdedit.diagram.SequenceDiagram;
import net.sf.sdedit.drawable.Arrow;

public abstract class Message
implements Constants {
    private final Lifeline caller;
    private final Lifeline callee;
    protected final SequenceDiagram diagram;
    private final MessageData data;
    private final SequenceConfiguration conf;
    private Arrow arrow;

    protected Message(Lifeline sender, Lifeline receiver, SequenceDiagram diagram, MessageData data) {
        this.caller = sender;
        this.callee = receiver;
        this.diagram = diagram;
        this.data = data;
        this.conf = diagram.getConfiguration();
    }

    public String toString() {
        return "{" + this.getClass().getSimpleName() + "} " + this.caller.toString() + " --[" + this.getText() + "]--> " + (this.callee == null ? "" : this.callee.toString());
    }

    public int getThread() {
        return this.caller.getThread();
    }

    protected final void setArrow(Arrow arrow) {
        this.arrow = arrow;
    }

    public final Arrow getArrow() {
        return this.arrow;
    }

    public void executeMessage() {
        this.execute();
        this.getDiagram().afterExecution(this);
    }

    protected abstract void execute();

    public final SequenceDiagram getDiagram() {
        return this.diagram;
    }

    public final Lifeline getCallee() {
        return this.callee;
    }

    public final Lifeline getCaller() {
        return this.caller;
    }

    public final MessageData getData() {
        return this.data;
    }

    public final SequenceConfiguration getConfiguration() {
        return this.conf;
    }

    public boolean isSynchronous() {
        return !this.data.isSpawnMessage() && !this.getCaller().isAlwaysActive() && !this.getCallee().isAlwaysActive();
    }

    protected final void extendLifelines(int amount) {
        this.diagram.extendLifelines(amount);
    }

    public abstract String getText();

    protected final int v() {
        return this.diagram.getVerticalPosition();
    }
}

