/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.builtins.BuiltinCallNode;
import com.oracle.graal.python.nodes.function.builtins.SlotWrapper;
import com.oracle.graal.python.nodes.function.builtins.WrapTpNewFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;

public final class WrapTpNew
extends SlotWrapper {
    private final PythonBuiltinClassType owner;
    @Node.Child
    private CheckNode checkNode;

    public WrapTpNew(BuiltinCallNode func, PythonBuiltinClassType owner) {
        super(func);
        this.owner = owner;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object cls;
        try {
            cls = PArguments.getArgument((Frame)frame, 1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException(String.valueOf(this.owner.getName()) + ".__new__ called without arguments");
        }
        if (cls != this.owner) {
            if (this.checkNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.checkNode = (CheckNode)this.insert(CheckNode.create());
            }
            this.checkNode.execute(this.owner, cls);
        }
        return super.execute(frame);
    }

    @GenerateInline(value=false)
    static abstract class CheckNode
    extends Node {
        CheckNode() {
        }

        abstract void execute(PythonBuiltinClassType var1, Object var2);

        @Specialization
        static void check(PythonBuiltinClassType owner, Object cls, @Bind Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached IsSubtypeNode isSubtypeNode, @Cached TpSlots.GetCachedTpSlotsNode getSlotsCls, @Cached TpSlots.GetCachedTpSlotsNode getSlotsBase1, @Cached TpSlots.GetCachedTpSlotsNode getSlotsBase2, @Cached TypeNodes.GetBaseClassNode getBase1, @Cached TypeNodes.GetBaseClassNode getBase2, @Cached InlinedLoopConditionProfile loopProfile, @Cached PRaiseNode raiseNotType, @Cached PRaiseNode raiseNotSubytpe, @Cached PRaiseNode raiseNotSafe) {
            if (!isTypeNode.execute(inliningTarget, cls)) {
                throw raiseNotType.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.NEW_X_ISNT_TYPE_OBJ, owner.getName(), cls);
            }
            if (!isSubtypeNode.execute(cls, (Object)owner)) {
                throw raiseNotSubytpe.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_SUBTYPE_OF, owner.getName(), cls, cls, owner.getName());
            }
            Object staticBase = cls;
            TpSlot staticBaseNew = getSlotsCls.execute(inliningTarget, staticBase).tp_new();
            if (staticBaseNew instanceof TpSlot.TpSlotPythonSingle) {
                staticBase = getBase1.execute(inliningTarget, staticBase);
                staticBaseNew = getSlotsBase1.execute(inliningTarget, staticBase).tp_new();
                while (loopProfile.profile(inliningTarget, staticBaseNew instanceof TpSlot.TpSlotPythonSingle)) {
                    staticBase = getBase2.execute(inliningTarget, staticBase);
                    staticBaseNew = getSlotsBase2.execute(inliningTarget, staticBase).tp_new();
                }
            }
            if (staticBaseNew != owner.getSlots().tp_new()) {
                throw raiseNotSafe.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.NEW_IS_NOT_SAFE_USE_ELSE, owner.getName(), cls, cls);
            }
        }

        @NeverDefault
        public static CheckNode create() {
            return WrapTpNewFactory.CheckNodeGen.create();
        }
    }
}

