/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python;

import com.oracle.graal.python.builtins.objects.ssl.LazyBouncyCastleProvider;
import com.oracle.graal.python.runtime.PythonImageBuildOptions;
import java.lang.reflect.Executable;
import java.security.Security;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

public class BouncyCastleFeature
implements Feature {
    private static final boolean INITIALIZE_AT_RUNTIME = false;

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (!PythonImageBuildOptions.WITHOUT_SSL) {
            String[] reflectiveClasses;
            RuntimeClassInitializationSupport support = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
            support.initializeAtBuildTime("org.bouncycastle", "security provider");
            support.initializeAtRunTime("org.bouncycastle.jcajce.provider.drbg.DRBG$Default", "RNG");
            support.initializeAtRunTime("org.bouncycastle.jcajce.provider.drbg.DRBG$NonceAndIV", "RNG");
            LazyBouncyCastleProvider.initProvider();
            for (String name : reflectiveClasses = new String[]{"com.sun.crypto.provider.HKDFKeyDerivation$HKDFSHA256", "com.sun.crypto.provider.HKDFKeyDerivation$HKDFSHA384", "com.sun.crypto.provider.HKDFKeyDerivation$HKDFSHA512", "sun.security.pkcs11.P11HKDF"}) {
                try {
                    Class.forName(name);
                }
                catch (ClassNotFoundException | SecurityException e) {
                    return;
                }
            }
            Security.addProvider(Security.getProvider("SunJCE"));
            for (String name : reflectiveClasses) {
                try {
                    RuntimeReflection.register((Class[])new Class[]{Class.forName(name)});
                    RuntimeReflection.register((Executable[])Class.forName(name).getConstructors());
                }
                catch (ClassNotFoundException | SecurityException e) {
                    throw new RuntimeException("Could not register " + name + " for reflective access!", e);
                }
            }
        }
    }
}

