/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.json4j;

import com.ibm.db2.cmx.internal.json4j.JSONArtifact;
import com.ibm.db2.cmx.internal.json4j.JSONObject;
import com.ibm.db2.cmx.internal.json4j.Serializer;
import com.ibm.db2.cmx.internal.json4j.SerializerVerbose;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class JSONArray
extends ArrayList
implements JSONArtifact {
    private static final long serialVersionUID = 9076798781015779954L;

    public JSONArray() {
    }

    public JSONArray(int n2) {
        super(n2);
    }

    @Override
    public void add(int n2, Object object) {
        this.checkElement(object);
        super.add(n2, object);
    }

    @Override
    public boolean add(Object object) {
        this.checkElement(object);
        return super.add(object);
    }

    @Override
    public boolean addAll(Collection collection) {
        this.checkElements(collection);
        return super.addAll(collection);
    }

    @Override
    public boolean addAll(int n2, Collection collection) {
        this.checkElements(collection);
        return super.addAll(n2, collection);
    }

    @Override
    public Object set(int n2, Object object) {
        this.checkElement(object);
        return super.set(n2, object);
    }

    public static JSONArray parse(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (Exception exception) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        return JSONArray.parse(inputStreamReader);
    }

    public static JSONArray parse(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(8196);
        stringBuilder.append("{\"jsonArray\":");
        char[] cArray = new char[8196];
        int n2 = 0;
        n2 = reader.read(cArray, 0, 8196);
        while (n2 != -1) {
            stringBuilder.append(cArray, 0, n2);
            n2 = reader.read(cArray, 0, 8196);
        }
        stringBuilder.append('}');
        JSONObject jSONObject = JSONObject.parse(stringBuilder.toString());
        return (JSONArray)jSONObject.get("jsonArray");
    }

    public static JSONArray parse(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        return JSONArray.parse(stringReader);
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        this.serialize(outputStream, false);
    }

    @Override
    public void serialize(OutputStream outputStream, boolean bl2) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IOException iOException = new IOException(unsupportedEncodingException.toString());
            iOException.initCause(unsupportedEncodingException);
            throw iOException;
        }
        this.serialize(bufferedWriter, bl2);
    }

    @Override
    public void serialize(Writer writer) throws IOException {
        writer = new BufferedWriter(writer);
        this.serialize(writer, false);
    }

    @Override
    public void serialize(Writer writer, boolean bl2) throws IOException {
        Serializer serializer = bl2 ? new SerializerVerbose(writer) : new Serializer(writer);
        serializer.writeArray(this).flush();
    }

    @Override
    public String serialize(boolean bl2) throws IOException {
        StringWriter stringWriter = new StringWriter();
        Serializer serializer = bl2 ? new SerializerVerbose(stringWriter) : new Serializer(stringWriter);
        serializer.writeArray(this).flush();
        return stringWriter.toString();
    }

    @Override
    public String serialize() throws IOException {
        return this.serialize(false);
    }

    private void checkElement(Object object) {
        if (!JSONObject.isValidObject(object)) {
            throw new IllegalArgumentException("invalid type of element");
        }
    }

    private void checkElements(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (JSONObject.isValidObject(iterator.next())) continue;
            throw new IllegalArgumentException("invalid type of element");
        }
    }
}

