/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.crawl.MutableResultsColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.ResultsColumn;
import schemacrawler.schema.ResultsColumns;

final class MutableResultsColumns
extends AbstractNamedObject
implements ResultsColumns {
    private static final long serialVersionUID = 5204766782914559188L;
    private final NamedObjectList<MutableResultsColumn> columns = new NamedObjectList();

    MutableResultsColumns(String name) {
        super(name);
    }

    @Override
    public List<ResultsColumn> getColumns() {
        return List.copyOf(this.columns.values());
    }

    @Override
    public String getColumnsListAsString() {
        String columnsList = "";
        List<ResultsColumn> columns = this.getColumns();
        if (columns != null && !columns.isEmpty()) {
            StringBuilder buffer = new StringBuilder(1024);
            for (int i = 0; i < columns.size(); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                ResultsColumn column = columns.get(i);
                buffer.append(column.getFullName());
            }
            columnsList = buffer.toString();
        }
        return columnsList;
    }

    @Override
    public Iterator<ResultsColumn> iterator() {
        return this.getColumns().iterator();
    }

    public Optional<MutableResultsColumn> lookupColumn(String name) {
        if (name == null) {
            return Optional.empty();
        }
        for (MutableResultsColumn column : this.columns) {
            if (!name.equalsIgnoreCase(column.getLabel()) && !name.equalsIgnoreCase(column.getFullName()) && !name.equalsIgnoreCase(column.getName())) continue;
            return Optional.of(column);
        }
        return Optional.empty();
    }

    void addColumn(MutableResultsColumn column) {
        this.columns.add(column);
    }
}

