/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.lib.CallTernaryOpNode;
import com.oracle.graal.python.lib.PyNumberPowerNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateInline(value=false)
@GenerateUncached
@OperationProxy.Proxyable
public abstract class PyNumberPowerNode
extends BinaryOpNode {
    public abstract Object execute(VirtualFrame var1, Object var2, Object var3, Object var4);

    @Override
    public final Object execute(VirtualFrame frame, Object left, Object right) {
        return this.execute(frame, left, right, PNone.NONE);
    }

    @Specialization
    public static Object doIt(VirtualFrame frame, Object v, Object w, Object z, @Bind Node inliningTarget, @Cached GetClassNode getVClass, @Cached GetClassNode getWClass, @Cached TpSlots.GetCachedTpSlotsNode getVSlots, @Cached TpSlots.GetCachedTpSlotsNode getWSlots, @Cached CallTernaryOpNode callTernaryOpNode, @Cached PRaiseNode raiseNode) {
        TpSlot slotW;
        assert (z != PNone.NO_VALUE);
        Object classV = getVClass.execute(inliningTarget, v);
        Object classW = getWClass.execute(inliningTarget, w);
        TpSlot slotV = getVSlots.execute(inliningTarget, classV).nb_power();
        Object result = callTernaryOpNode.execute(frame, inliningTarget, v, classV, slotV, w, classW, slotW = getWSlots.execute(inliningTarget, classW).nb_power(), z);
        if (result != PNotImplemented.NOT_IMPLEMENTED) {
            return result;
        }
        return PyNumberPowerNode.raiseNotSupported(inliningTarget, v, w, z, raiseNode);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseNotSupported(Node inliningTarget, Object v, Object w, Object z, PRaiseNode raiseNode) {
        if (z == PNone.NONE) {
            return raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_AND_P, "** or pow()", v, w);
        }
        return raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_TYPES_FOR_S_P_P_P, "** or pow()", v, w, z);
    }

    @NeverDefault
    public static PyNumberPowerNode create() {
        return PyNumberPowerNodeGen.create();
    }

    public static PyNumberPowerNode getUncached() {
        return PyNumberPowerNodeGen.getUncached();
    }
}

