/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.cfg;

import java.util.Collection;
import java.util.function.UnaryOperator;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.databind.AbstractTypeResolver;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.InjectableValues;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.ConfigOverrides;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.DatatypeFeatures;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MutableConfigOverride;
import tools.jackson.databind.cfg.PackageVersion;
import tools.jackson.databind.deser.DeserializationProblemHandler;
import tools.jackson.databind.deser.DeserializerFactory;
import tools.jackson.databind.deser.Deserializers;
import tools.jackson.databind.deser.KeyDeserializers;
import tools.jackson.databind.deser.ValueDeserializerModifier;
import tools.jackson.databind.deser.ValueInstantiators;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.ser.SerializerFactory;
import tools.jackson.databind.ser.Serializers;
import tools.jackson.databind.ser.ValueSerializerModifier;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.type.TypeModifier;

public class ModuleContextBase
implements JacksonModule.SetupContext {
    protected final MapperBuilder<?, ?> _builder;
    protected final ConfigOverrides _configOverrides;

    public ModuleContextBase(MapperBuilder<?, ?> b, ConfigOverrides configOverrides) {
        this._builder = b;
        this._configOverrides = configOverrides;
    }

    public void applyChanges(MapperBuilder<?, ?> b) {
    }

    @Override
    public Version getMapperVersion() {
        return PackageVersion.VERSION;
    }

    @Override
    public String getFormatName() {
        return this._streamFactory().getFormatName();
    }

    @Override
    public Object getOwner() {
        return this._builder;
    }

    @Override
    public TypeFactory typeFactory() {
        return this._builder.typeFactory();
    }

    @Override
    public TokenStreamFactory tokenStreamFactory() {
        return this._streamFactory();
    }

    @Override
    public boolean isEnabled(MapperFeature f) {
        return this._builder.isEnabled(f);
    }

    @Override
    public boolean isEnabled(DeserializationFeature f) {
        return this._builder.isEnabled(f);
    }

    @Override
    public boolean isEnabled(SerializationFeature f) {
        return this._builder.isEnabled(f);
    }

    @Override
    public boolean isEnabled(TokenStreamFactory.Feature f) {
        return this._streamFactory().isEnabled(f);
    }

    @Override
    public boolean isEnabled(StreamReadFeature f) {
        return this._builder.isEnabled(f);
    }

    @Override
    public boolean isEnabled(StreamWriteFeature f) {
        return this._builder.isEnabled(f);
    }

    @Override
    public boolean isEnabled(DatatypeFeature f) {
        return this._builder.isEnabled(f);
    }

    @Override
    public DatatypeFeatures datatypeFeatures() {
        return this._builder.datatypeFeatures();
    }

    @Override
    public JacksonModule.SetupContext addDeserializers(Deserializers d) {
        this._set(this._deserializerFactory().withAdditionalDeserializers(d));
        return this;
    }

    @Override
    public JacksonModule.SetupContext addKeyDeserializers(KeyDeserializers kd) {
        this._set(this._deserializerFactory().withAdditionalKeyDeserializers(kd));
        return this;
    }

    @Override
    public JacksonModule.SetupContext addDeserializerModifier(ValueDeserializerModifier modifier) {
        this._set(this._deserializerFactory().withDeserializerModifier(modifier));
        return this;
    }

    @Override
    public JacksonModule.SetupContext addValueInstantiators(ValueInstantiators instantiators) {
        this._set(this._deserializerFactory().withValueInstantiators(instantiators));
        return this;
    }

    @Override
    public JacksonModule.SetupContext addSerializers(Serializers s) {
        this._set(this._serializerFactory().withAdditionalSerializers(s));
        return this;
    }

    @Override
    public JacksonModule.SetupContext addKeySerializers(Serializers s) {
        this._set(this._serializerFactory().withAdditionalKeySerializers(s));
        return this;
    }

    @Override
    public JacksonModule.SetupContext addSerializerModifier(ValueSerializerModifier modifier) {
        this._set(this._serializerFactory().withSerializerModifier(modifier));
        return this;
    }

    @Override
    public JacksonModule.SetupContext overrideDefaultNullKeySerializer(ValueSerializer<?> ser) {
        this._set(this._serializerFactory().withNullKeySerializer(ser));
        return this;
    }

    @Override
    public JacksonModule.SetupContext overrideDefaultNullValueSerializer(ValueSerializer<?> ser) {
        this._set(this._serializerFactory().withNullValueSerializer(ser));
        return this;
    }

    @Override
    public JacksonModule.SetupContext addAbstractTypeResolver(AbstractTypeResolver resolver) {
        this._builder.addAbstractTypeResolver(resolver);
        return this;
    }

    @Override
    public JacksonModule.SetupContext addTypeModifier(TypeModifier modifier) {
        this._builder.addTypeModifier(modifier);
        return this;
    }

    @Override
    public JacksonModule.SetupContext registerSubtypes(Class<?> ... subtypes) {
        this._builder.subtypeResolver().registerSubtypes(subtypes);
        return this;
    }

    @Override
    public JacksonModule.SetupContext registerSubtypes(NamedType ... subtypes) {
        this._builder.subtypeResolver().registerSubtypes(subtypes);
        return this;
    }

    @Override
    public JacksonModule.SetupContext registerSubtypes(Collection<Class<?>> subtypes) {
        this._builder.subtypeResolver().registerSubtypes(subtypes);
        return this;
    }

    @Override
    public JacksonModule.SetupContext insertAnnotationIntrospector(AnnotationIntrospector ai) {
        this._builder.baseSettings(this._builder.baseSettings().withInsertedAnnotationIntrospector(ai));
        return this;
    }

    @Override
    public JacksonModule.SetupContext appendAnnotationIntrospector(AnnotationIntrospector ai) {
        this._builder.baseSettings(this._builder.baseSettings().withAppendedAnnotationIntrospector(ai));
        return this;
    }

    @Override
    public MutableConfigOverride configOverride(Class<?> type) {
        return this._configOverrides.findOrCreateOverride(type);
    }

    @Override
    public JacksonModule.SetupContext addHandler(DeserializationProblemHandler handler) {
        this._builder.addHandler(handler);
        return this;
    }

    @Override
    public JacksonModule.SetupContext overrideInjectableValues(UnaryOperator<InjectableValues> v) {
        InjectableValues oldV = this._builder.injectableValues();
        InjectableValues newV = (InjectableValues)v.apply(oldV);
        if (newV != oldV) {
            this._builder.injectableValues(newV);
        }
        return this;
    }

    @Override
    public JacksonModule.SetupContext setMixIn(Class<?> target, Class<?> mixinSource) {
        this._builder.addMixIn(target, mixinSource);
        return this;
    }

    protected TokenStreamFactory _streamFactory() {
        return this._builder.streamFactory();
    }

    protected DeserializerFactory _deserializerFactory() {
        return this._builder.deserializerFactory();
    }

    protected void _set(DeserializerFactory f) {
        this._builder.deserializerFactory(f);
    }

    protected SerializerFactory _serializerFactory() {
        return this._builder.serializerFactory();
    }

    protected void _set(SerializerFactory f) {
        this._builder.serializerFactory(f);
    }
}

