/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.debug;

import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedDirectCallNode;
import com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import com.oracle.truffle.runtime.OptimizedTruffleRuntimeListener;
import java.util.Map;

public final class TraceSplittingListener
implements OptimizedTruffleRuntimeListener {
    private int splitCount;

    private TraceSplittingListener() {
    }

    public static void install(OptimizedTruffleRuntime runtime) {
        runtime.addListener(new TraceSplittingListener());
    }

    @Override
    public void onCompilationSplit(OptimizedDirectCallNode callNode) {
        OptimizedCallTarget callTarget = callNode.getCallTarget();
        if (callTarget.getOptionValue(OptimizedRuntimeOptions.TraceSplitting).booleanValue()) {
            String label = String.format("split %3s-%s-%-4s ", this.splitCount++, callNode.getCurrentCallTarget().id, callNode.getCallCount());
            Map<String, Object> debugProperties = callTarget.getDebugProperties();
            debugProperties.put("SourceSection", TraceSplittingListener.extractSourceSection(callNode));
            OptimizedTruffleRuntime.getRuntime().logEvent(callTarget, 0, label, debugProperties);
        }
    }

    @Override
    public void onCompilationSplitFailed(OptimizedDirectCallNode callNode, CharSequence reason) {
        OptimizedCallTarget callTarget = callNode.getCallTarget();
        if (callTarget.getOptionValue(OptimizedRuntimeOptions.TraceSplitting).booleanValue()) {
            String label = String.format("split failed " + String.valueOf(reason), new Object[0]);
            Map<String, Object> debugProperties = callTarget.getDebugProperties();
            debugProperties.put("SourceSection", TraceSplittingListener.extractSourceSection(callNode));
            OptimizedTruffleRuntime.getRuntime().logEvent(callTarget, 0, label, debugProperties);
        }
    }

    private static String extractSourceSection(OptimizedDirectCallNode node) {
        OptimizedDirectCallNode cnode = node;
        while (cnode.getSourceSection() == null && !(cnode instanceof RootNode)) {
            if ((cnode = cnode.getParent()) != null) continue;
            return "";
        }
        return TraceSplittingListener.getShortDescription(cnode.getSourceSection());
    }

    static String getShortDescription(SourceSection sourceSection) {
        if (sourceSection == null) {
            return "<Unknown>";
        }
        StringBuilder b = new StringBuilder();
        if (sourceSection.getSource().getPath() == null) {
            b.append(sourceSection.getSource().getName());
        } else {
            b.append(sourceSection.getSource().getPath());
        }
        b.append("~").append(TraceSplittingListener.formatIndices(sourceSection, true));
        return b.toString();
    }

    static String formatIndices(SourceSection sourceSection, boolean needsColumnSpecifier) {
        boolean singleLine;
        StringBuilder b = new StringBuilder();
        boolean bl = singleLine = sourceSection.getStartLine() == sourceSection.getEndLine();
        if (singleLine) {
            b.append(sourceSection.getStartLine());
        } else {
            b.append(sourceSection.getStartLine()).append("-").append(sourceSection.getEndLine());
        }
        if (needsColumnSpecifier) {
            b.append(":");
            if (sourceSection.getCharLength() <= 1) {
                b.append(sourceSection.getCharIndex());
            } else {
                b.append(sourceSection.getCharIndex()).append("-").append(sourceSection.getCharIndex() + sourceSection.getCharLength() - 1);
            }
        }
        return b.toString();
    }
}

