/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class IntervaldsAccessor
extends Accessor {
    static final int MAXLENGTH = 11;
    private static int INTERVALDSOFFSET;
    private static int INTERVALDAYOFFSET;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    IntervaldsAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(Representation.INTERVALDS, stmt, 11, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$6, null, stmt, max_len, form, external_type, forBind);
            }
            this.init(stmt, 183, 183, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    IntervaldsAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.INTERVALDS, stmt, 11, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$7, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            this.init(stmt, 183, 183, form, false);
            this.initForDescribe(183, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Duration getDuration(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$0, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                Duration duration = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$0, this, duration);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$0, this, null);
                }
                return null;
            }
            byte[] bytes = this.getBytesInternal((int)currentRow);
            long d2 = (bytes[0] & 0xFF) << 24;
            d2 |= (long)((bytes[1] & 0xFF) << 16);
            d2 |= (long)((bytes[2] & 0xFF) << 8);
            d2 |= (long)(bytes[3] & 0xFF);
            d2 -= (long)INTERVALDAYOFFSET;
            long h2 = bytes[4] - INTERVALDSOFFSET;
            long m2 = bytes[5] - INTERVALDSOFFSET;
            long s2 = bytes[6] - INTERVALDSOFFSET;
            int n3 = (bytes[7] & 0xFF) << 24;
            n3 |= (bytes[8] & 0xFF) << 16;
            n3 |= (bytes[9] & 0xFF) << 8;
            n3 |= bytes[10] & 0xFF;
            Duration duration = Duration.ofSeconds(d2 * 86400L + h2 * 3600L + m2 * 60L + s2, n3 -= INTERVALDAYOFFSET);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$0, this, duration);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$0, this, null);
            }
            return duration;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$1, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$1, this, string);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$1, this, null);
                }
                return null;
            }
            String string = this.getINTERVALDS((int)currentRow).toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$1, this, string);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$1, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$2, this, n2);
            }
            INTERVALDS iNTERVALDS = this.getINTERVALDS((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$2, this, iNTERVALDS);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$2, this, null);
            }
            return iNTERVALDS;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$3, this, n2);
            }
            INTERVALDS iNTERVALDS = this.getINTERVALDS((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$3, this, iNTERVALDS);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$3, this, null);
            }
            return iNTERVALDS;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$4, this, n2, map);
            }
            INTERVALDS iNTERVALDS = this.getINTERVALDS((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$4, this, iNTERVALDS);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$4, this, null);
            }
            return iNTERVALDS;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    INTERVALDS getINTERVALDS(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$5, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                INTERVALDS iNTERVALDS = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$5, this, iNTERVALDS);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            INTERVALDS iNTERVALDS = new INTERVALDS(this.getBytesInternal((int)currentRow));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$5, this, iNTERVALDS);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$5, this, null);
            }
            return iNTERVALDS;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, IntervaldsAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$7 = IntervaldsAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = IntervaldsAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = IntervaldsAccessor.class.getDeclaredMethod("getINTERVALDS", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = IntervaldsAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = IntervaldsAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = IntervaldsAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = IntervaldsAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = IntervaldsAccessor.class.getDeclaredMethod("getDuration", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        INTERVALDSOFFSET = 60;
        INTERVALDAYOFFSET = Integer.MIN_VALUE;
    }
}

