/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.runtime.AsyncHandler;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;

public class NFILZMASupport {
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(NFILZMASupport.class);
    public static final int FORMAT_AUTO_INDEX = 0;
    public static final int FORMAT_XZ_INDEX = 1;
    public static final int FORMAT_ALONE_INDEX = 2;
    public static final int FORMAT_RAW_INDEX = 3;
    public static final int CHECK_NONE_INDEX = 0;
    public static final int CHECK_CRC32_INDEX = 1;
    public static final int CHECK_CRC64_INDEX = 2;
    public static final int CHECK_SHA256_INDEX = 3;
    public static final int CHECK_ID_MAX_INDEX = 4;
    public static final int CHECK_UNKNOWN_INDEX = 5;
    public static final int FILTER_LZMA1_INDEX = 0;
    public static final int FILTER_LZMA2_INDEX = 1;
    public static final int FILTER_DELTA_INDEX = 2;
    public static final int FILTER_X86_INDEX = 3;
    public static final int FILTER_POWERPC_INDEX = 4;
    public static final int FILTER_IA64_INDEX = 5;
    public static final int FILTER_ARM_INDEX = 6;
    public static final int FILTER_ARMTHUMB_INDEX = 7;
    public static final int FILTER_SPARC_INDEX = 8;
    public static final int MF_HC3_INDEX = 0;
    public static final int MF_HC4_INDEX = 1;
    public static final int MF_BT2_INDEX = 2;
    public static final int MF_BT3_INDEX = 3;
    public static final int MF_BT4_INDEX = 4;
    public static final int MODE_FAST_INDEX = 0;
    public static final int MODE_NORMAL_INDEX = 1;
    public static final int PRESET_DEFAULT_INDEX = 0;
    public static final int PRESET_EXTREME_INDEX = 1;
    public static final int ID_INDEX = 0;
    public static final int PRESET_INDEX = 1;
    public static final int DICT_SIZE_INDEX = 2;
    public static final int LC_INDEX = 3;
    public static final int LP_INDEX = 4;
    public static final int PB_INDEX = 5;
    public static final int MODE_INDEX = 6;
    public static final int NICE_LEN_INDEX = 7;
    public static final int MF_INDEX = 8;
    public static final int DEPTH_INDEX = 9;
    public static final int DIST_INDEX = 1;
    public static final int START_OFFSET_INDEX = 1;
    public static final int MAX_OPTS_INDEX = 10;
    public static final int LZMA_ID_ERROR = 98;
    public static final int LZMA_PRESET_ERROR = 99;
    private static final String SUPPORTING_NATIVE_LIB_NAME = "lzmasupport";
    private final PythonContext pythonContext;
    private final NativeLibrary.TypedNativeLibrary<LZMANativeFunctions> typedNativeLib;
    @CompilerDirectives.CompilationFinal
    private boolean available;

    private NFILZMASupport(PythonContext context, NativeLibrary.NFIBackend backend, String noNativeAccessHelp) {
        if (context.useNativeCompressionModules()) {
            this.pythonContext = context;
            this.typedNativeLib = NativeLibrary.create((String)PythonContext.getSupportLibName(SUPPORTING_NATIVE_LIB_NAME), (Enum[])LZMANativeFunctions.values(), (NativeLibrary.NFIBackend)backend, (String)noNativeAccessHelp, (boolean)true);
            this.available = true;
        } else {
            this.pythonContext = null;
            this.typedNativeLib = null;
            this.available = false;
        }
    }

    public static NFILZMASupport createNative(PythonContext context, String noNativeAccessHelp) {
        return new NFILZMASupport(context, NativeLibrary.NFIBackend.NATIVE, noNativeAccessHelp);
    }

    public static NFILZMASupport createLLVM(PythonContext context, String noNativeAccessHelp) {
        return new NFILZMASupport(context, NativeLibrary.NFIBackend.LLVM, noNativeAccessHelp);
    }

    public void notAvailable() {
        if (this.available) {
            CompilerAsserts.neverPartOfCompilation((String)"Checking NFILZMASupport availability should only be done during initialization.");
            this.available = false;
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    public Object getMacros(int[] formats, int[] checks, long[] filters, int[] mfs, int[] modes, long[] preset) {
        return this.typedNativeLib.callUncached(this.pythonContext, LZMANativeFunctions.get_macros, formats, checks, filters, mfs, modes, preset);
    }

    public Object getTimeElapsed(Object lzmast) {
        return this.typedNativeLib.callUncached(this.pythonContext, LZMANativeFunctions.lzma_get_timeElapsed, lzmast);
    }

    public Object gcReleaseHelper(Object lzmast) {
        return this.typedNativeLib.callUncached(this.pythonContext, LZMANativeFunctions.lzma_gc_helper, lzmast);
    }

    public Object createStream(NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.call(this.typedNativeLib, LZMANativeFunctions.lzma_create_lzmast_stream, new Object[0]);
    }

    public void deallocateStream(Object lzmast, NativeLibrary.InvokeNativeFunction invokeNode2) {
        invokeNode2.call(this.typedNativeLib, LZMANativeFunctions.lzma_free_stream, lzmast);
    }

    public long getNextInIndex(Object lzmast, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this.typedNativeLib, LZMANativeFunctions.lzma_get_next_in_index, lzmast);
    }

    public long getLzsAvailIn(Object lzmast, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this.typedNativeLib, LZMANativeFunctions.lzma_get_lzs_avail_in, lzmast);
    }

    public long getLzsAvailOut(Object lzmast, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this.typedNativeLib, LZMANativeFunctions.lzma_get_lzs_avail_out, lzmast);
    }

    public int getLzsCheck(Object lzmast, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_lzma_get_check, lzmast);
    }

    public void setLzsAvailIn(Object lzmast, long v, NativeLibrary.InvokeNativeFunction invokeNode2) {
        invokeNode2.call(this.typedNativeLib, LZMANativeFunctions.lzma_set_lzs_avail_in, lzmast, v);
    }

    public long getOutputBufferSize(Object lzmast, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callLong(this.typedNativeLib, LZMANativeFunctions.lzma_get_output_buffer_size, lzmast);
    }

    public void getOutputBuffer(Object lzmast, byte[] dest, NativeLibrary.InvokeNativeFunction invokeNode2) {
        invokeNode2.call(this.typedNativeLib, LZMANativeFunctions.lzma_get_output_buffer, lzmast, dest);
    }

    public int checkIsSupported(int check_id, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_lzma_check_is_supported, check_id);
    }

    public int setFilterSpecLZMA(Object lzmast, int fidx, long[] opts, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_set_filter_spec_lzma, lzmast, fidx, opts);
    }

    public int setFilterSpecDelta(Object lzmast, int fidx, long[] opts, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_set_filter_spec_delta, lzmast, fidx, opts);
    }

    public int setFilterSpecBCJ(Object lzmast, int fidx, long[] opts, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_set_filter_spec_bcj, lzmast, fidx, opts);
    }

    public int encodeFilter(Object lzmast, long[] opts, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_encode_filter_spec, lzmast, opts);
    }

    public int decodeFilter(long filter_id, byte[] encoded_props, int len, long[] opts, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_decode_filter_spec, filter_id, encoded_props, len, opts);
    }

    public int lzmaEasyEncoder(Object lzmast, long preset, int check, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_lzma_easy_encoder, lzmast, preset, check);
    }

    public int lzmaStreamEncoder(Object lzmast, int check, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_lzma_stream_encoder, lzmast, check);
    }

    public int lzmaAloneEncoderPreset(Object lzmast, long preset, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_lzma_alone_encoder_preset, lzmast, preset);
    }

    public int lzmaAloneEncoder(Object lzmast, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_lzma_alone_encoder, lzmast);
    }

    public int lzmaRawEncoder(Object lzmast, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_lzma_raw_encoder, lzmast);
    }

    public int compress(Object lzmast, byte[] data, long len, int iaction, long bufsize, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_compress, lzmast, data, len, iaction, bufsize);
    }

    public int lzmaRawDecoder(Object lzmast, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_lzma_raw_decoder, lzmast);
    }

    public int lzmaAutoDecoder(Object lzmast, long memlimit, long decoder_flags, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_lzma_auto_decoder, lzmast, memlimit, decoder_flags);
    }

    public int lzmaStreamDecoder(Object lzmast, long memlimit, long decoder_flags, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_lzma_stream_decoder, lzmast, memlimit, decoder_flags);
    }

    public int lzmaAloneDecoder(Object lzmast, long memlimit, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_lzma_alone_decoder, lzmast, memlimit);
    }

    public int decompress(Object lzmast, byte[] input_buffer, long offset, long max_length, long bufsize, long lzs_avail_in, NativeLibrary.InvokeNativeFunction invokeNode2) {
        return invokeNode2.callInt(this.typedNativeLib, LZMANativeFunctions.lzma_decompress, lzmast, input_buffer, offset, max_length, bufsize, lzs_avail_in);
    }

    static enum LZMANativeFunctions implements NativeLibrary.NativeFunction
    {
        get_macros("([SINT32], [SINT32], [UINT64], [SINT32], [SINT32], [UINT64]): VOID"),
        lzma_create_lzmast_stream("(): POINTER"),
        lzma_get_timeElapsed("(POINTER): DOUBLE"),
        lzma_free_stream("(POINTER): VOID"),
        lzma_gc_helper("(POINTER): VOID"),
        lzma_get_next_in_index("(POINTER): SINT64"),
        lzma_get_lzs_avail_in("(POINTER): UINT64"),
        lzma_get_lzs_avail_out("(POINTER): UINT64"),
        lzma_lzma_get_check("(POINTER): SINT32"),
        lzma_set_lzs_avail_in("(POINTER, UINT64): VOID"),
        lzma_get_output_buffer_size("(POINTER): UINT64"),
        lzma_get_output_buffer("(POINTER, [UINT8]): VOID"),
        lzma_lzma_check_is_supported("(SINT32): SINT32"),
        lzma_set_filter_spec_lzma("(POINTER, SINT32, [SINT64]): SINT32"),
        lzma_set_filter_spec_delta("(POINTER, SINT32, [SINT64]): SINT32"),
        lzma_set_filter_spec_bcj("(POINTER, SINT32, [SINT64]): SINT32"),
        lzma_encode_filter_spec("(POINTER, [SINT64]): SINT32"),
        lzma_decode_filter_spec("(SINT64, [UINT8], SINT32, [SINT64]): SINT32"),
        lzma_lzma_easy_encoder("(POINTER, UINT32, SINT32): SINT32"),
        lzma_lzma_stream_encoder("(POINTER, SINT32): SINT32"),
        lzma_lzma_alone_encoder_preset("(POINTER, UINT32): SINT32"),
        lzma_lzma_alone_encoder("(POINTER): SINT32"),
        lzma_lzma_raw_encoder("(POINTER): SINT32"),
        lzma_compress("(POINTER, [UINT8], UINT64, SINT32, SINT64): SINT32"),
        lzma_lzma_raw_decoder("(POINTER): SINT32"),
        lzma_lzma_auto_decoder("(POINTER, UINT64, UINT32): SINT32"),
        lzma_lzma_stream_decoder("(POINTER, UINT64, UINT32): SINT32"),
        lzma_lzma_alone_decoder("(POINTER, UINT64): SINT32"),
        lzma_decompress("(POINTER, [UINT8], SINT64, SINT64, SINT64, UINT64): SINT32");

        private final String signature;

        private LZMANativeFunctions(String signature) {
            this.signature = signature;
        }

        @Override
        public String signature() {
            return this.signature;
        }
    }

    public static class Pointer
    extends AsyncHandler.SharedFinalizer.FinalizableReference {
        private final NFILZMASupport lib;

        public Pointer(Object referent, Object ptr, NFILZMASupport lib) {
            super(referent, ptr, lib.pythonContext.getSharedFinalizer());
            this.lib = lib;
        }

        protected void doRelease() {
            this.lib.gcReleaseHelper(this.getReference());
        }

        @Override
        public AsyncHandler.AsyncAction release() {
            if (!this.isReleased()) {
                return new PointerReleaseCallback(this);
            }
            return null;
        }
    }

    static class PointerReleaseCallback
    implements AsyncHandler.AsyncAction {
        private final Pointer pointer;

        public PointerReleaseCallback(Pointer pointer) {
            this.pointer = pointer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(PythonContext context) {
            Pointer pointer = this.pointer;
            synchronized (pointer) {
                if (this.pointer.isReleased()) {
                    return;
                }
                try {
                    this.pointer.doRelease();
                    this.pointer.markReleased();
                    LOGGER.finest("NFILZMASupport pointer has been freed");
                }
                catch (Exception e) {
                    LOGGER.severe("Error while trying to free NFILZMASupport pointer: " + e.getMessage());
                }
            }
        }
    }
}

