let _ = Mltop.add_known_module "rocq-runtime.plugins.ltac"

# 13 "plugins/ltac/extraargs.mlg"
 

open Pp
open Stdarg
open Tacarg
open Procq.Prim
open Procq.Constr
open Names
open Taccoerce
open Tacinterp
open Locus

(** Adding scopes for generic arguments not defined through ARGUMENT EXTEND *)

(** We need g_ltac to initialize tactic_value *)
let () = G_ltac.for_extraargs

let create_generic_quotation name e wit =
  let inject (loc, v) = Tacexpr.TacGeneric (Some name, Genarg.in_gen (Genarg.rawwit wit) v) in
  Tacentries.create_ltac_quotation ~plugin:"rocq-runtime.plugins.ltac" name inject (e, None)

let () = create_generic_quotation "integer" Procq.Prim.integer Stdarg.wit_int
let () = create_generic_quotation "string" Procq.Prim.string Stdarg.wit_string

let () = create_generic_quotation "smart_global" Procq.Prim.smart_global Stdarg.wit_smart_global

let () = create_generic_quotation "ident" Procq.Prim.ident Stdarg.wit_ident
let () = create_generic_quotation "reference" Procq.Prim.reference Stdarg.wit_ref
let () = create_generic_quotation "uconstr" Procq.Constr.lconstr Stdarg.wit_uconstr
let () = create_generic_quotation "constr" Procq.Constr.lconstr Stdarg.wit_constr
let () = create_generic_quotation "ipattern" Pltac.simple_intropattern wit_simple_intropattern
let () = create_generic_quotation "open_constr" Procq.Constr.lconstr Stdarg.wit_open_constr
let () =
  let inject (loc, v) = Tacexpr.Tacexp v in
  Tacentries.create_ltac_quotation ~plugin:"rocq-runtime.plugins.ltac" "ltac" inject (Pltac.ltac_expr, Some 5)

(** Backward-compatible tactic notation entry names *)

let () =
  let register name entry = Tacentries.register_tactic_notation_entry name entry in
  register "hyp" wit_hyp;
  register "simple_intropattern" wit_simple_intropattern;
  register "integer" wit_integer;
  register "reference" wit_ref;
  ()

(* Rewriting orientation *)

let pr_orient _prc _prlc _prt = function
  | true -> Pp.mt ()
  | false -> Pp.str " <-"


# 58 "plugins/ltac/extraargs.ml"

let (wit_orient, orient) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"orient" 
                           {
                           Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                    ([(Procq.Production.make
                                                       (Procq.Rule.stop)
                                                       (fun loc -> 
# 70 "plugins/ltac/extraargs.mlg"
           true 
# 68 "plugins/ltac/extraargs.ml"
));
                                                     (Procq.Production.make
                                                      (Procq.Rule.next
                                                       (Procq.Rule.stop)
                                                       ((Procq.Symbol.token (Procq.terminal "<-"))))
                                                      (fun _ loc -> 
# 69 "plugins/ltac/extraargs.mlg"
                false 
# 77 "plugins/ltac/extraargs.ml"
));
                                                     (Procq.Production.make
                                                      (Procq.Rule.next
                                                       (Procq.Rule.stop)
                                                       ((Procq.Symbol.token (Procq.terminal "->"))))
                                                      (fun _ loc -> 
# 68 "plugins/ltac/extraargs.mlg"
                true 
# 86 "plugins/ltac/extraargs.ml"
))]);
                           Tacentries.arg_tag = Some
                                                (Geninterp.val_tag (Genarg.topwit wit_bool));
                           Tacentries.arg_intern = Tacentries.ArgInternWit (wit_bool);
                           Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_bool);
                           Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_bool);
                           Tacentries.arg_printer = ((fun env sigma -> 
                                                    
# 67 "plugins/ltac/extraargs.mlg"
                                                  pr_orient 
# 97 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                    
# 67 "plugins/ltac/extraargs.mlg"
                                                  pr_orient 
# 102 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                    
# 67 "plugins/ltac/extraargs.mlg"
                                                  pr_orient 
# 107 "plugins/ltac/extraargs.ml"
));
                           }
let _ = (wit_orient, orient)


# 73 "plugins/ltac/extraargs.mlg"
 

let pr_int _ _ _ i = Pp.int i

let _natural = Procq.Prim.natural


# 121 "plugins/ltac/extraargs.ml"

let (wit_natural, natural) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"natural" 
                             {
                             Tacentries.arg_parsing = Vernacextend.Arg_alias
                                                      (_natural);
                             Tacentries.arg_tag = Some
                                                  (Geninterp.val_tag (Genarg.topwit wit_int));
                             Tacentries.arg_intern = Tacentries.ArgInternWit (wit_int);
                             Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_int);
                             Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_int);
                             Tacentries.arg_printer = ((fun env sigma -> 
                                                      
# 81 "plugins/ltac/extraargs.mlg"
                                                  pr_int 
# 136 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                      
# 81 "plugins/ltac/extraargs.mlg"
                                                  pr_int 
# 141 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                      
# 81 "plugins/ltac/extraargs.mlg"
                                                  pr_int 
# 146 "plugins/ltac/extraargs.ml"
));
                             }
let _ = (wit_natural, natural)


# 85 "plugins/ltac/extraargs.mlg"
 

let pr_orient = pr_orient () () ()

let pr_int_list = Pp.pr_sequence Pp.int
let pr_int_list_full _prc _prlc _prt l = pr_int_list l

let pr_occurrences _prc _prlc _prt l =
  match l with
    | ArgArg x -> pr_int_list x
    | ArgVar { CAst.loc = loc; v=id } -> Id.print id

let occurrences_of = function
  | [] -> NoOccurrences
  | n::_ as nl when n < 0 -> AllOccurrencesBut (List.map abs nl)
  | nl ->
      if List.exists (fun n -> n < 0) nl then
        CErrors.user_err Pp.(str "Illegal negative occurrence number.");
      OnlyOccurrences nl

let coerce_to_int v = match Value.to_int v with
  | None -> raise (CannotCoerceTo "an integer")
  | Some n -> n

let int_list_of_VList v = match Value.to_list v with
| Some l -> List.map (fun n -> coerce_to_int n) l
| _ -> raise (CannotCoerceTo "an integer")

let interp_occs ist env sigma l =
  match l with
    | ArgArg x -> x
    | ArgVar ({ CAst.v = id } as locid) ->
        (try int_list_of_VList (Id.Map.find id ist.lfun)
          with Not_found | CannotCoerceTo _ -> [interp_int ist locid])

let glob_occs ist l = l

let subst_occs evm l = l


# 193 "plugins/ltac/extraargs.ml"

let (wit_occurrences, occurrences) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"occurrences" 
                                     {
                                     Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                              ([(Procq.Production.make
                                                                 (Procq.Rule.next
                                                                  (Procq.Rule.stop)
                                                                  ((Procq.Symbol.nterm hyp)))
                                                                 (fun id
                                                                 loc -> 
                                                                 
# 138 "plugins/ltac/extraargs.mlg"
                   ArgVar id 
# 207 "plugins/ltac/extraargs.ml"
));
                                                               (Procq.Production.make
                                                                (Procq.Rule.next
                                                                 (Procq.Rule.stop)
                                                                 ((Procq.Symbol.list1 ((Procq.Symbol.nterm integer)))))
                                                                (fun l loc ->
                                                                
# 137 "plugins/ltac/extraargs.mlg"
                              ArgArg l 
# 217 "plugins/ltac/extraargs.ml"
))]);
                                     Tacentries.arg_tag = Some
                                                          (Geninterp.Val.List 
                                                          (Geninterp.val_tag (Genarg.topwit wit_int)));
                                     Tacentries.arg_intern = Tacentries.ArgInternFun ((fun f ist v -> (ist, f ist v)) (
                                                             
# 131 "plugins/ltac/extraargs.mlg"
                  glob_occs 
# 226 "plugins/ltac/extraargs.ml"
));
                                     Tacentries.arg_subst = Tacentries.ArgSubstFun (
                                                            
# 132 "plugins/ltac/extraargs.mlg"
                   subst_occs 
# 232 "plugins/ltac/extraargs.ml"
);
                                     Tacentries.arg_interp = Tacentries.ArgInterpSimple (
                                                             
# 130 "plugins/ltac/extraargs.mlg"
                   interp_occs 
# 238 "plugins/ltac/extraargs.ml"
);
                                     Tacentries.arg_printer = ((fun env sigma -> 
                                                              
# 134 "plugins/ltac/extraargs.mlg"
                   pr_occurrences 
# 244 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                              
# 135 "plugins/ltac/extraargs.mlg"
                    pr_occurrences 
# 249 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                              
# 128 "plugins/ltac/extraargs.mlg"
               pr_int_list_full 
# 254 "plugins/ltac/extraargs.ml"
));
                                     }
let _ = (wit_occurrences, occurrences)


# 141 "plugins/ltac/extraargs.mlg"
 

let pr_occurrences = pr_occurrences () () ()

let pr_gen env sigma prc _prlc _prtac x = prc env sigma x

let pr_globc env sigma lvl _prc _prlc _prtac glob =
  Printer.pr_closed_glob_n_env env sigma lvl glob

let interp_glob ist env sigma t = Tacinterp.interp_glob_closure ist env sigma t

let glob_glob = Tacintern.intern_constr

let pr_lconstr env sigma _ prc _ c = prc env sigma c

let subst_glob = Tacsubst.subst_glob_constr_and_expr


# 279 "plugins/ltac/extraargs.ml"

let (wit_glob, glob) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"glob" 
                       {
                       Tacentries.arg_parsing = Vernacextend.Arg_alias
                                                (constr);
                       Tacentries.arg_tag = None;
                       Tacentries.arg_intern = Tacentries.ArgInternFun ((fun f ist v -> (ist, f ist v)) (
                                               
# 164 "plugins/ltac/extraargs.mlg"
                     glob_glob 
# 290 "plugins/ltac/extraargs.ml"
));
                       Tacentries.arg_subst = Tacentries.ArgSubstFun (
# 165 "plugins/ltac/extraargs.mlg"
                      subst_glob 
# 295 "plugins/ltac/extraargs.ml"
);
                       Tacentries.arg_interp = Tacentries.ArgInterpSimple (
# 163 "plugins/ltac/extraargs.mlg"
                      interp_glob 
# 300 "plugins/ltac/extraargs.ml"
);
                       Tacentries.arg_printer = ((fun env sigma -> 
# 167 "plugins/ltac/extraargs.mlg"
                      pr_gen env sigma 
# 305 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                
# 168 "plugins/ltac/extraargs.mlg"
                       pr_gen env sigma 
# 310 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                
# 161 "plugins/ltac/extraargs.mlg"
                 fun c -> pr_globc env sigma Ppconstr.lsimpleconstr c 
# 315 "plugins/ltac/extraargs.ml"
));
                       }
let _ = (wit_glob, glob)


# 172 "plugins/ltac/extraargs.mlg"
 

let l_constr = Procq.Constr.lconstr


# 327 "plugins/ltac/extraargs.ml"

let (wit_lconstr, lconstr) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"lconstr" 
                             {
                             Tacentries.arg_parsing = Vernacextend.Arg_alias
                                                      (l_constr);
                             Tacentries.arg_tag = Some
                                                  (Geninterp.val_tag (Genarg.topwit wit_constr));
                             Tacentries.arg_intern = Tacentries.ArgInternWit (wit_constr);
                             Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_constr);
                             Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_constr);
                             Tacentries.arg_printer = ((fun env sigma -> 
                                                      
# 180 "plugins/ltac/extraargs.mlg"
                 pr_lconstr env sigma 
# 342 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                      
# 180 "plugins/ltac/extraargs.mlg"
                 pr_lconstr env sigma 
# 347 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                      
# 180 "plugins/ltac/extraargs.mlg"
                 pr_lconstr env sigma 
# 352 "plugins/ltac/extraargs.ml"
));
                             }
let _ = (wit_lconstr, lconstr)

let (wit_lglob, lglob) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"lglob" 
                         {
                         Tacentries.arg_parsing = Vernacextend.Arg_alias
                                                  (lconstr);
                         Tacentries.arg_tag = Some
                                              (Geninterp.val_tag (Genarg.topwit wit_glob));
                         Tacentries.arg_intern = Tacentries.ArgInternFun ((fun f ist v -> (ist, f ist v)) (
                                                 
# 189 "plugins/ltac/extraargs.mlg"
                     glob_glob 
# 367 "plugins/ltac/extraargs.ml"
));
                         Tacentries.arg_subst = Tacentries.ArgSubstFun (
# 190 "plugins/ltac/extraargs.mlg"
                      subst_glob 
# 372 "plugins/ltac/extraargs.ml"
);
                         Tacentries.arg_interp = Tacentries.ArgInterpSimple (
                                                 
# 188 "plugins/ltac/extraargs.mlg"
                      interp_glob 
# 378 "plugins/ltac/extraargs.ml"
);
                         Tacentries.arg_printer = ((fun env sigma -> 
                                                  
# 192 "plugins/ltac/extraargs.mlg"
                      pr_gen env sigma 
# 384 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                  
# 193 "plugins/ltac/extraargs.mlg"
                       pr_gen env sigma 
# 389 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                  
# 186 "plugins/ltac/extraargs.mlg"
                 fun c -> pr_globc env sigma Ppconstr.ltop c 
# 394 "plugins/ltac/extraargs.ml"
));
                         }
let _ = (wit_lglob, lglob)


# 197 "plugins/ltac/extraargs.mlg"
 

type 'id gen_place = ('id * hyp_location_flag) option

type loc_place = lident gen_place
type place = Id.t gen_place

let pr_gen_place pr_id = function
| None -> Pp.mt ()
| Some (id, InHyp) -> str "in " ++ pr_id id
| Some (id, InHypTypeOnly) ->
  str "in (type of " ++ pr_id id ++ str ")"
| Some (id, InHypValueOnly) ->
  str "in (value of " ++ pr_id id ++ str ")"

let pr_loc_place _ _ _ = pr_gen_place (fun { CAst.v = id } -> Id.print id)
let pr_place _ _ _ = pr_gen_place Id.print
let pr_hloc = pr_loc_place () () ()

let intern_place ist = function
| None -> None
| Some (id, hl) -> Some (Tacintern.intern_hyp ist id, hl)

let interp_place ist env sigma = function
| None -> None
| Some (id, hl) -> Some (Tacinterp.interp_hyp ist env sigma id, hl)

let subst_place subst pl = pl


# 431 "plugins/ltac/extraargs.ml"

let (wit_hloc, hloc) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"hloc" 
                       {
                       Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                ([(Procq.Production.make
                                                   (Procq.Rule.next
                                                    (Procq.Rule.next
                                                     (Procq.Rule.next
                                                      (Procq.Rule.next
                                                       (Procq.Rule.next
                                                        (Procq.Rule.next
                                                         (Procq.Rule.stop)
                                                         ((Procq.Symbol.token (Procq.terminal "in"))))
                                                        ((Procq.Symbol.token (Procq.terminal "("))))
                                                       ((Procq.Symbol.token (Procq.terminal "value"))))
                                                      ((Procq.Symbol.token (Procq.terminal "of"))))
                                                     ((Procq.Symbol.nterm ident)))
                                                    ((Procq.Symbol.token (Procq.terminal ")"))))
                                                   (fun _ id _ _ _ _ loc -> 
# 244 "plugins/ltac/extraargs.mlg"
      Some ((CAst.make id), InHypValueOnly) 
# 453 "plugins/ltac/extraargs.ml"
));
                                                 (Procq.Production.make
                                                  (Procq.Rule.next
                                                   (Procq.Rule.next
                                                    (Procq.Rule.next
                                                     (Procq.Rule.next
                                                      (Procq.Rule.next
                                                       (Procq.Rule.next
                                                        (Procq.Rule.stop)
                                                        ((Procq.Symbol.token (Procq.terminal "in"))))
                                                       ((Procq.Symbol.token (Procq.terminal "("))))
                                                      ((Procq.Symbol.token (Procq.terminal "type"))))
                                                     ((Procq.Symbol.token (Procq.terminal "of"))))
                                                    ((Procq.Symbol.nterm ident)))
                                                   ((Procq.Symbol.token (Procq.terminal ")"))))
                                                  (fun _ id _ _ _ _ loc -> 
# 242 "plugins/ltac/extraargs.mlg"
      Some ((CAst.make id), InHypTypeOnly) 
# 472 "plugins/ltac/extraargs.ml"
));
                                                 (Procq.Production.make
                                                  (Procq.Rule.next
                                                   (Procq.Rule.next
                                                    (Procq.Rule.stop)
                                                    ((Procq.Symbol.token (Procq.terminal "in"))))
                                                   ((Procq.Symbol.nterm ident)))
                                                  (fun id _ loc -> 
# 240 "plugins/ltac/extraargs.mlg"
      Some ((CAst.make id), InHyp) 
# 483 "plugins/ltac/extraargs.ml"
));
                                                 (Procq.Production.make
                                                  (Procq.Rule.next
                                                   (Procq.Rule.next
                                                    (Procq.Rule.next
                                                     (Procq.Rule.stop)
                                                     ((Procq.Symbol.token (Procq.terminal "in"))))
                                                    ((Procq.Symbol.token (Procq.terminal "|-"))))
                                                   ((Procq.Symbol.token (Procq.terminal "*"))))
                                                  (fun _ _ _ loc -> 
# 238 "plugins/ltac/extraargs.mlg"
      None 
# 496 "plugins/ltac/extraargs.ml"
));
                                                 (Procq.Production.make
                                                  (Procq.Rule.stop)
                                                  (fun loc -> 
# 236 "plugins/ltac/extraargs.mlg"
      None 
# 503 "plugins/ltac/extraargs.ml"
))]);
                       Tacentries.arg_tag = None;
                       Tacentries.arg_intern = Tacentries.ArgInternFun ((fun f ist v -> (ist, f ist v)) (
                                               
# 231 "plugins/ltac/extraargs.mlg"
                    intern_place 
# 510 "plugins/ltac/extraargs.ml"
));
                       Tacentries.arg_subst = Tacentries.ArgSubstFun (
# 232 "plugins/ltac/extraargs.mlg"
                     subst_place 
# 515 "plugins/ltac/extraargs.ml"
);
                       Tacentries.arg_interp = Tacentries.ArgInterpSimple (
# 230 "plugins/ltac/extraargs.mlg"
                     interp_place 
# 520 "plugins/ltac/extraargs.ml"
);
                       Tacentries.arg_printer = ((fun env sigma -> 
# 233 "plugins/ltac/extraargs.mlg"
                     pr_loc_place 
# 525 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                
# 234 "plugins/ltac/extraargs.mlg"
                      pr_loc_place 
# 530 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                
# 229 "plugins/ltac/extraargs.mlg"
                 pr_place 
# 535 "plugins/ltac/extraargs.ml"
));
                       }
let _ = (wit_hloc, hloc)


# 248 "plugins/ltac/extraargs.mlg"
 

let pr_rename _ _ _ (n, m) = Id.print n ++ str " into " ++ Id.print m


# 547 "plugins/ltac/extraargs.ml"

let (wit_rename, rename) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"rename" 
                           {
                           Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                    ([(Procq.Production.make
                                                       (Procq.Rule.next
                                                        (Procq.Rule.next
                                                         (Procq.Rule.next
                                                          (Procq.Rule.stop)
                                                          ((Procq.Symbol.nterm ident)))
                                                         ((Procq.Symbol.token (Procq.terminal "into"))))
                                                        ((Procq.Symbol.nterm ident)))
                                                       (fun m _ n loc -> 
# 257 "plugins/ltac/extraargs.mlg"
                                    (n, m) 
# 563 "plugins/ltac/extraargs.ml"
))]);
                           Tacentries.arg_tag = Some
                                                (Geninterp.Val.Pair (
                                                (Geninterp.val_tag (Genarg.topwit wit_ident)), 
                                                (Geninterp.val_tag (Genarg.topwit wit_ident))));
                           Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.PairArg (
                                                   (wit_ident), (wit_ident)));
                           Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.PairArg (
                                                  (wit_ident), (wit_ident)));
                           Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.PairArg (
                                                   (wit_ident), (wit_ident)));
                           Tacentries.arg_printer = ((fun env sigma -> 
                                                    
# 256 "plugins/ltac/extraargs.mlg"
               pr_rename 
# 579 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                    
# 256 "plugins/ltac/extraargs.mlg"
               pr_rename 
# 584 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                    
# 256 "plugins/ltac/extraargs.mlg"
               pr_rename 
# 589 "plugins/ltac/extraargs.ml"
));
                           }
let _ = (wit_rename, rename)


# 262 "plugins/ltac/extraargs.mlg"
 

let pr_by_arg_tac env sigma _prc _prlc prtac opt_c =
  match opt_c with
    | None -> mt ()
    | Some t -> hov 2 (str "by" ++ spc () ++ prtac env sigma (Constrexpr.LevelLe 3) t)


# 604 "plugins/ltac/extraargs.ml"

let (wit_by_arg_tac, by_arg_tac) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"by_arg_tac" 
                                   {
                                   Tacentries.arg_parsing = Vernacextend.Arg_rules
                                                            ([(Procq.Production.make
                                                               (Procq.Rule.stop)
                                                               (fun loc -> 
# 275 "plugins/ltac/extraargs.mlg"
           None 
# 614 "plugins/ltac/extraargs.ml"
));
                                                             (Procq.Production.make
                                                              (Procq.Rule.next
                                                               (Procq.Rule.next
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.token (Procq.terminal "by"))))
                                                               ((Procq.Symbol.nterml Pltac.ltac_expr ("3"))))
                                                              (fun c _ loc ->
                                                              
# 274 "plugins/ltac/extraargs.mlg"
                           Some c 
# 626 "plugins/ltac/extraargs.ml"
))]);
                                   Tacentries.arg_tag = Some
                                                        (Geninterp.Val.Opt 
                                                        (Geninterp.val_tag (Genarg.topwit wit_tactic)));
                                   Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.OptArg 
                                                           (wit_tactic));
                                   Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.OptArg 
                                                          (wit_tactic));
                                   Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.OptArg 
                                                           (wit_tactic));
                                   Tacentries.arg_printer = ((fun env sigma -> 
                                                            
# 273 "plugins/ltac/extraargs.mlg"
               pr_by_arg_tac env sigma 
# 641 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                            
# 273 "plugins/ltac/extraargs.mlg"
               pr_by_arg_tac env sigma 
# 646 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                            
# 273 "plugins/ltac/extraargs.mlg"
               pr_by_arg_tac env sigma 
# 651 "plugins/ltac/extraargs.ml"
));
                                   }
let _ = (wit_by_arg_tac, by_arg_tac)


# 278 "plugins/ltac/extraargs.mlg"
 

let pr_by_arg_tac env sigma prtac opt_c = pr_by_arg_tac env sigma () () prtac opt_c

let pr_in_clause _ _ _ cl = Pptactic.pr_in_clause Pputils.pr_lident cl
let pr_in_top_clause _ _ _ cl = Pptactic.pr_in_clause Id.print cl
let in_clause' = Pltac.in_clause


# 667 "plugins/ltac/extraargs.ml"

let (wit_in_clause, in_clause) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"in_clause" 
                                 {
                                 Tacentries.arg_parsing = Vernacextend.Arg_alias
                                                          (in_clause');
                                 Tacentries.arg_tag = Some
                                                      (Geninterp.val_tag (Genarg.topwit wit_clause_dft_concl));
                                 Tacentries.arg_intern = Tacentries.ArgInternWit (wit_clause_dft_concl);
                                 Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_clause_dft_concl);
                                 Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_clause_dft_concl);
                                 Tacentries.arg_printer = ((fun env sigma -> 
                                                          
# 291 "plugins/ltac/extraargs.mlg"
                   pr_in_clause 
# 682 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                          
# 292 "plugins/ltac/extraargs.mlg"
                    pr_in_clause 
# 687 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                          
# 290 "plugins/ltac/extraargs.mlg"
               pr_in_top_clause 
# 692 "plugins/ltac/extraargs.ml"
));
                                 }
let _ = (wit_in_clause, in_clause)


# 296 "plugins/ltac/extraargs.mlg"
 

let local_test_lpar_id_colon =
  let open Procq.Lookahead in
  to_entry "lpar_id_colon" begin
    lk_kw "(" >> lk_ident >> lk_kw ":"
  end

let pr_lpar_id_colon _ _ _ _ = mt ()


# 710 "plugins/ltac/extraargs.ml"

let (wit_test_lpar_id_colon, test_lpar_id_colon) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"test_lpar_id_colon" 
                                                   {
                                                   Tacentries.arg_parsing = 
                                                   Vernacextend.Arg_rules
                                                   ([(Procq.Production.make
                                                      (Procq.Rule.next
                                                       (Procq.Rule.stop)
                                                       ((Procq.Symbol.nterm local_test_lpar_id_colon)))
                                                      (fun x loc -> 
# 309 "plugins/ltac/extraargs.mlg"
                                       () 
# 723 "plugins/ltac/extraargs.ml"
))]);
                                                   Tacentries.arg_tag = 
                                                   Some
                                                   (Geninterp.val_tag (Genarg.topwit wit_unit));
                                                   Tacentries.arg_intern = 
                                                   Tacentries.ArgInternWit (wit_unit);
                                                   Tacentries.arg_subst = 
                                                   Tacentries.ArgSubstWit (wit_unit);
                                                   Tacentries.arg_interp = 
                                                   Tacentries.ArgInterpWit (wit_unit);
                                                   Tacentries.arg_printer = 
                                                   ((fun env sigma -> 
                                                   
# 308 "plugins/ltac/extraargs.mlg"
                                                              pr_lpar_id_colon 
# 739 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                   
# 308 "plugins/ltac/extraargs.mlg"
                                                              pr_lpar_id_colon 
# 744 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                   
# 308 "plugins/ltac/extraargs.mlg"
                                                              pr_lpar_id_colon 
# 749 "plugins/ltac/extraargs.ml"
));
                                                   }
let _ = (wit_test_lpar_id_colon, test_lpar_id_colon)


# 312 "plugins/ltac/extraargs.mlg"
 

(* Work around a limitation of the macro system *)
let strategy_level0 = Procq.Prim.strategy_level

let pr_strategy _ _ _ v = Conv_oracle.pr_level v


# 764 "plugins/ltac/extraargs.ml"

let (wit_strategy_level, strategy_level) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"strategy_level" 
                                           {
                                           Tacentries.arg_parsing = Vernacextend.Arg_alias
                                                                    (strategy_level0);
                                           Tacentries.arg_tag = None;
                                           Tacentries.arg_intern = Tacentries.ArgInternFun (fun ist v -> (ist, v));
                                           Tacentries.arg_subst = Tacentries.ArgSubstFun (fun s v -> v);
                                           Tacentries.arg_interp = Tacentries.ArgInterpRet;
                                           Tacentries.arg_printer = ((fun env sigma -> 
                                                                    
# 321 "plugins/ltac/extraargs.mlg"
                                            pr_strategy 
# 778 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                                    
# 321 "plugins/ltac/extraargs.mlg"
                                            pr_strategy 
# 783 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                                    
# 321 "plugins/ltac/extraargs.mlg"
                                            pr_strategy 
# 788 "plugins/ltac/extraargs.ml"
));
                                           }
let _ = (wit_strategy_level, strategy_level)


# 325 "plugins/ltac/extraargs.mlg"
 

let intern_strategy ist v = match v with
| ArgVar id -> ArgVar (Tacintern.intern_hyp ist id)
| ArgArg v -> ArgArg v

let subst_strategy _ v = v

let interp_strategy ist env sigma = function
| ArgArg n -> n
| ArgVar { CAst.v = id; CAst.loc } ->
  let v =
    try Id.Map.find id ist.lfun
    with Not_found ->
      CErrors.user_err ?loc
        (str "Unbound variable " ++ Id.print id ++ str".")
  in
  let v =
    try Tacinterp.Value.cast (Genarg.topwit wit_strategy_level) v
    with CErrors.UserError _ -> Taccoerce.error_ltac_variable ?loc id None v "a strategy_level"
  in
  v

let pr_loc_strategy _ _ _ v = Pputils.pr_or_var Conv_oracle.pr_level v


# 821 "plugins/ltac/extraargs.ml"

let (wit_strategy_level_or_var, strategy_level_or_var) = Tacentries.argument_extend ~plugin:"rocq-runtime.plugins.ltac" ~name:"strategy_level_or_var" 
                                                         {
                                                         Tacentries.arg_parsing = 
                                                         Vernacextend.Arg_rules
                                                         ([(Procq.Production.make
                                                            (Procq.Rule.next
                                                             (Procq.Rule.stop)
                                                             ((Procq.Symbol.nterm identref)))
                                                            (fun id loc -> 
# 361 "plugins/ltac/extraargs.mlg"
                        ArgVar id 
# 834 "plugins/ltac/extraargs.ml"
));
                                                          (Procq.Production.make
                                                           (Procq.Rule.next
                                                            (Procq.Rule.stop)
                                                            ((Procq.Symbol.nterm strategy_level)))
                                                           (fun n loc -> 
# 360 "plugins/ltac/extraargs.mlg"
                             ArgArg n 
# 843 "plugins/ltac/extraargs.ml"
))]);
                                                         Tacentries.arg_tag = 
                                                         Some
                                                         (Geninterp.val_tag (Genarg.topwit wit_strategy_level));
                                                         Tacentries.arg_intern = 
                                                         Tacentries.ArgInternFun ((fun f ist v -> (ist, f ist v)) (
                                                         
# 356 "plugins/ltac/extraargs.mlg"
                    intern_strategy 
# 853 "plugins/ltac/extraargs.ml"
));
                                                         Tacentries.arg_subst = 
                                                         Tacentries.ArgSubstFun (
                                                         
# 357 "plugins/ltac/extraargs.mlg"
                     subst_strategy 
# 860 "plugins/ltac/extraargs.ml"
);
                                                         Tacentries.arg_interp = 
                                                         Tacentries.ArgInterpSimple (
                                                         
# 355 "plugins/ltac/extraargs.mlg"
                     interp_strategy 
# 867 "plugins/ltac/extraargs.ml"
);
                                                         Tacentries.arg_printer = 
                                                         ((fun env sigma -> 
                                                         
# 358 "plugins/ltac/extraargs.mlg"
                     pr_loc_strategy 
# 874 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                         
# 359 "plugins/ltac/extraargs.mlg"
                      pr_loc_strategy 
# 879 "plugins/ltac/extraargs.ml"
), (fun env sigma -> 
                                                         
# 354 "plugins/ltac/extraargs.mlg"
                 pr_strategy 
# 884 "plugins/ltac/extraargs.ml"
));
                                                         }
let _ = (wit_strategy_level_or_var, strategy_level_or_var)

