/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

public class BackSlash {
    public static final String BS_BS_N = "\\n";
    public static final String NEWLINE = "\n";
    public static final char CHAR_NEWLINE = '\n';

    public static final String lineSeparator() {
        return System.lineSeparator();
    }

    public static char hiddenNewLine() {
        return '\ue100';
    }

    public static String translateBackSlashes(CharSequence s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i < s.length() - 1 && BackSlash.isEnglishLetterOfBackSlash(s.charAt(i + 1))) {
                result.append('\\');
                result.append(BackSlash.translateChar(s.charAt(i + 1)));
                ++i;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static boolean isEnglishLetterOfBackSlash(char c) {
        return c == 'n';
    }

    public static String untranslateBackSlashes(CharSequence s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\ue000' && c < '\ue07f') {
                c = (char)(c - 57344);
            }
            result.append(c);
        }
        return result.toString();
    }

    private static char translateChar(char c) {
        if (c > '\u0080') {
            throw new IllegalArgumentException();
        }
        return (char)(57344 + c);
    }
}

