/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.stats.ParsedGenerated;
import net.sourceforge.plantuml.version.Version;

public class HistoricalData {
    private final Preferences prefs;
    private ParsedGenerated current;
    private final List<ParsedGenerated> historical = new ArrayList<ParsedGenerated>();

    HistoricalData(Preferences prefs) {
        this.prefs = prefs;
        try {
            this.historical.addAll(this.reload());
        }
        catch (BackingStoreException e) {
            Logme.error(e);
        }
        Collections.sort(this.historical, this.getIdComparator());
    }

    public void reset() {
        char currentCode = (char)(65 + this.historical.size());
        if (this.historical.size() > 7) {
            ParsedGenerated last = this.historical.get(0);
            String lastName = last.parsed().getName();
            currentCode = lastName.charAt("histo.".length());
        }
        this.current = ParsedGenerated.loadDated(this.prefs, "histo." + currentCode);
        this.current.reset();
        long maxId = this.getMaxId();
        this.current.parsedDated().setComment(Long.toString(maxId + 1L, 36) + "/" + Version.versionString());
    }

    private long getMaxId() {
        long v = 0L;
        for (ParsedGenerated histo : this.historical) {
            v = Math.max(v, histo.getId());
        }
        return v;
    }

    private Comparator<? super ParsedGenerated> getIdComparator() {
        return new Comparator<ParsedGenerated>(){

            @Override
            public int compare(ParsedGenerated v1, ParsedGenerated v2) {
                long time2;
                long time1 = v1.getId();
                if (time1 > (time2 = v2.getId())) {
                    return 1;
                }
                if (time1 < time2) {
                    return -1;
                }
                return 0;
            }
        };
    }

    private List<ParsedGenerated> reload() throws BackingStoreException {
        ArrayList<ParsedGenerated> result = new ArrayList<ParsedGenerated>();
        int length = "histo.".length();
        for (String key : this.prefs.keys()) {
            if (!key.startsWith("histo.") || !key.endsWith(".p.saved")) continue;
            String name = key.substring(length, length + 1);
            ParsedGenerated load = ParsedGenerated.loadDated(this.prefs, "histo." + name);
            result.add(load);
        }
        return result;
    }

    public ParsedGenerated current() {
        return this.current;
    }

    public List<ParsedGenerated> getHistorical() {
        return Collections.unmodifiableList(this.historical);
    }
}

