/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.lookup;

import java.util.Set;
import java.util.function.BiFunction;
import org.apache.calcite.schema.lookup.ConcatLookup;
import org.apache.calcite.schema.lookup.EmptyLookup;
import org.apache.calcite.schema.lookup.LikePattern;
import org.apache.calcite.schema.lookup.NameMapLookup;
import org.apache.calcite.schema.lookup.Named;
import org.apache.calcite.schema.lookup.TransformingLookup;
import org.apache.calcite.util.NameMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Lookup<T> {
    public @Nullable T get(String var1);

    public @Nullable Named<T> getIgnoreCase(String var1);

    public Set<String> getNames(LikePattern var1);

    default public <S> Lookup<S> map(BiFunction<T, String, S> mapper) {
        return new TransformingLookup<T, S>(this, mapper);
    }

    public static <T> @Nullable T get(Lookup<T> lookup, String name, boolean caseSensitive) {
        if (caseSensitive) {
            T entry = lookup.get(name);
            if (entry == null) {
                return null;
            }
            return entry;
        }
        return Named.entityOrNull(lookup.getIgnoreCase(name));
    }

    public static <T> Lookup<T> empty() {
        return EmptyLookup.INSTANCE;
    }

    public static <T> Lookup<T> of(NameMap<T> map) {
        return new NameMapLookup<T>(map);
    }

    public static <T> Lookup<T> concat(Lookup<T> ... lookups) {
        return new ConcatLookup<T>(lookups);
    }
}

